/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.model.entry;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.sf.jabref.model.entry.Author;
import net.sf.jabref.model.entry.AuthorList;

public class AuthorListParser {
    private String original;
    private int tokenStart;
    private int tokenEnd;
    private int tokenAbbr;
    private char tokenTerm;
    private boolean tokenCase;
    private static final Set<String> TEX_NAMES = new HashSet<String>();
    private static final int TOKEN_GROUP_LENGTH = 4;
    private static final int OFFSET_TOKEN = 0;
    private static final int OFFSET_TOKEN_ABBR = 1;
    private static final int OFFSET_TOKEN_TERM = 2;
    private static final int TOKEN_EOF = 0;
    private static final int TOKEN_AND = 1;
    private static final int TOKEN_COMMA = 2;
    private static final int TOKEN_WORD = 3;

    public AuthorList parse(String listOfNames) {
        Objects.requireNonNull(listOfNames);
        this.original = listOfNames;
        this.tokenStart = 0;
        this.tokenEnd = 0;
        ArrayList<Author> authors = new ArrayList<Author>(5);
        while (this.tokenStart < this.original.length()) {
            this.getAuthor().ifPresent(authors::add);
        }
        return new AuthorList(authors);
    }

    private Optional<Author> getAuthor() {
        String jrPart;
        int firstPartEnd;
        ArrayList<Object> tokens = new ArrayList<Object>();
        int vonStart = -1;
        int lastStart = -1;
        int commaFirst = -1;
        int commaSecond = -1;
        boolean continueLoop = true;
        while (continueLoop) {
            int token = this.getToken();
            switch (token) {
                case 0: 
                case 1: {
                    continueLoop = false;
                    break;
                }
                case 2: {
                    if (commaFirst < 0) {
                        commaFirst = tokens.size();
                        break;
                    }
                    if (commaSecond >= 0) break;
                    commaSecond = tokens.size();
                    break;
                }
                case 3: {
                    tokens.add(this.original.substring(this.tokenStart, this.tokenEnd));
                    tokens.add(this.original.substring(this.tokenStart, this.tokenAbbr));
                    tokens.add(Character.valueOf(this.tokenTerm));
                    tokens.add(this.tokenCase);
                    if (commaFirst >= 0 || lastStart >= 0) break;
                    if (vonStart < 0) {
                        int previousTermToken;
                        if (this.tokenCase || (previousTermToken = tokens.size() - 4 - 4 + 2) >= 0 && tokens.get(previousTermToken).equals(Character.valueOf('-'))) break;
                        vonStart = tokens.size() - 4;
                        break;
                    }
                    if (lastStart >= 0 || !this.tokenCase) break;
                    lastStart = tokens.size() - 4;
                    break;
                }
            }
        }
        if (tokens.isEmpty()) {
            return Optional.empty();
        }
        int firstPartStart = -1;
        int vonPartStart = -1;
        int lastPartStart = -1;
        int jrPartStart = -1;
        int vonPartEnd = 0;
        int lastPartEnd = 0;
        int jrPartEnd = 0;
        if (commaFirst < 0) {
            if (vonStart < 0) {
                Character ch;
                lastPartEnd = tokens.size();
                lastPartStart = tokens.size() - 4;
                int index = tokens.size() - 8 + 2;
                if (index > 0 && (ch = (Character)tokens.get(index)).charValue() == '-') {
                    lastPartStart -= 4;
                }
                if ((firstPartEnd = lastPartStart) > 0) {
                    firstPartStart = 0;
                }
            } else {
                if (lastStart >= 0) {
                    lastPartEnd = tokens.size();
                    vonPartEnd = lastPartStart = lastStart;
                } else {
                    vonPartEnd = tokens.size();
                }
                firstPartEnd = vonPartStart = vonStart;
                if (firstPartEnd > 0) {
                    firstPartStart = 0;
                }
            }
        } else {
            firstPartEnd = tokens.size();
            if (commaSecond < 0) {
                if (commaFirst < firstPartEnd) {
                    firstPartStart = commaFirst;
                }
            } else {
                if (commaSecond < firstPartEnd) {
                    firstPartStart = commaSecond;
                }
                if (commaFirst < (jrPartEnd = commaSecond)) {
                    jrPartStart = commaFirst;
                }
            }
            if (vonStart == 0) {
                if (lastStart < 0) {
                    vonPartEnd = commaFirst;
                } else {
                    lastPartEnd = commaFirst;
                    vonPartEnd = lastPartStart = lastStart;
                }
                vonPartStart = 0;
            } else {
                lastPartEnd = commaFirst;
                if (lastPartEnd > 0) {
                    lastPartStart = 0;
                }
            }
        }
        if (firstPartStart == -1 && lastPartStart == -1 && vonPartStart != -1) {
            lastPartStart = vonPartStart;
            lastPartEnd = vonPartEnd;
            vonPartStart = -1;
            vonPartEnd = -1;
        }
        String firstPart = firstPartStart < 0 ? null : this.concatTokens(tokens, firstPartStart, firstPartEnd, 0, false);
        String firstAbbr = firstPartStart < 0 ? null : this.concatTokens(tokens, firstPartStart, firstPartEnd, 1, true);
        String vonPart = vonPartStart < 0 ? null : this.concatTokens(tokens, vonPartStart, vonPartEnd, 0, false);
        String lastPart = lastPartStart < 0 ? null : this.concatTokens(tokens, lastPartStart, lastPartEnd, 0, false);
        String string = jrPart = jrPartStart < 0 ? null : this.concatTokens(tokens, jrPartStart, jrPartEnd, 0, false);
        if (firstPart != null && lastPart != null && lastPart.equals(lastPart.toUpperCase()) && lastPart.length() < 5) {
            return Optional.of(new Author(lastPart, lastPart, vonPart, firstPart, jrPart));
        }
        return Optional.of(new Author(firstPart, firstAbbr, vonPart, lastPart, jrPart));
    }

    private String concatTokens(List<Object> tokens, int start, int end, int offset, boolean dotAfter) {
        StringBuilder result = new StringBuilder();
        result.append((String)tokens.get(start + offset));
        if (dotAfter) {
            result.append('.');
        }
        for (int updatedStart = start + 4; updatedStart < end; updatedStart += 4) {
            result.append(tokens.get(updatedStart - 4 + 2));
            result.append((String)tokens.get(updatedStart + offset));
            if (!dotAfter) continue;
            result.append('.');
        }
        return result.toString();
    }

    private int getToken() {
        char c;
        this.tokenStart = this.tokenEnd;
        while (this.tokenStart < this.original.length() && ((c = this.original.charAt(this.tokenStart)) == '~' || c == '-' || Character.isWhitespace(c))) {
            ++this.tokenStart;
        }
        this.tokenEnd = this.tokenStart;
        if (this.tokenStart >= this.original.length()) {
            return 0;
        }
        if (this.original.charAt(this.tokenStart) == ',') {
            ++this.tokenEnd;
            return 2;
        }
        if (this.original.charAt(this.tokenStart) == ';') {
            ++this.tokenEnd;
            return 1;
        }
        this.tokenAbbr = -1;
        this.tokenTerm = (char)32;
        this.tokenCase = true;
        int bracesLevel = 0;
        int currentBackslash = -1;
        boolean firstLetterIsFound = false;
        while (this.tokenEnd < this.original.length()) {
            char c2 = this.original.charAt(this.tokenEnd);
            if (c2 == '{') {
                ++bracesLevel;
            }
            if (firstLetterIsFound && this.tokenAbbr < 0 && (bracesLevel == 0 || c2 == '{')) {
                this.tokenAbbr = this.tokenEnd;
            }
            if (c2 == '}' && bracesLevel > 0) {
                --bracesLevel;
            }
            if (!firstLetterIsFound && currentBackslash < 0 && Character.isLetter(c2)) {
                this.tokenCase = bracesLevel == 0 ? Character.isUpperCase(c2) : true;
                firstLetterIsFound = true;
            }
            if (currentBackslash >= 0 && !Character.isLetter(c2)) {
                String texCmdName;
                if (!firstLetterIsFound && TEX_NAMES.contains(texCmdName = this.original.substring(currentBackslash + 1, this.tokenEnd))) {
                    this.tokenCase = Character.isUpperCase(texCmdName.charAt(0));
                    firstLetterIsFound = true;
                }
                currentBackslash = -1;
            }
            if (c2 == '\\') {
                currentBackslash = this.tokenEnd;
            }
            if (bracesLevel == 0 && (",;~-".indexOf(c2) != -1 || Character.isWhitespace(c2))) break;
            ++this.tokenEnd;
        }
        if (this.tokenAbbr < 0) {
            this.tokenAbbr = this.tokenEnd;
        }
        if (this.tokenEnd < this.original.length() && this.original.charAt(this.tokenEnd) == '-') {
            this.tokenTerm = (char)45;
        }
        if ("and".equalsIgnoreCase(this.original.substring(this.tokenStart, this.tokenEnd))) {
            return 1;
        }
        return 3;
    }

    static {
        TEX_NAMES.add("aa");
        TEX_NAMES.add("ae");
        TEX_NAMES.add("l");
        TEX_NAMES.add("o");
        TEX_NAMES.add("oe");
        TEX_NAMES.add("i");
        TEX_NAMES.add("AA");
        TEX_NAMES.add("AE");
        TEX_NAMES.add("L");
        TEX_NAMES.add("O");
        TEX_NAMES.add("OE");
        TEX_NAMES.add("j");
    }
}

