/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.model.entry;

import java.util.Objects;
import java.util.Optional;

public class Author {
    private final String firstPart;
    private final String firstAbbr;
    private final String vonPart;
    private final String lastPart;
    private final String jrPart;

    public Author(String first, String firstabbr, String von, String last, String jr) {
        this.firstPart = Author.addDotIfAbbreviation(this.removeStartAndEndBraces(first));
        this.firstAbbr = this.removeStartAndEndBraces(firstabbr);
        this.vonPart = this.removeStartAndEndBraces(von);
        this.lastPart = this.removeStartAndEndBraces(last);
        this.jrPart = this.removeStartAndEndBraces(jr);
    }

    public static String addDotIfAbbreviation(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        if (name.length() == 1 && Character.isLetter(name.charAt(0)) && Character.isUpperCase(name.charAt(0))) {
            return name + ".";
        }
        StringBuilder sb = new StringBuilder();
        char lastChar = name.charAt(0);
        for (int i = 0; i < name.length(); ++i) {
            char furtherChar;
            boolean lastIsLowercaseLetter;
            boolean currentIsUppercaseLetter;
            if (i > 0) {
                lastChar = name.charAt(i - 1);
            }
            char currentChar = name.charAt(i);
            sb.append(currentChar);
            if (currentChar == '.' && i + 1 < name.length() && Character.isUpperCase(name.charAt(i + 1))) {
                sb.append(' ');
            }
            boolean bl = currentIsUppercaseLetter = Character.isLetter(currentChar) && Character.isUpperCase(currentChar);
            if (!currentIsUppercaseLetter) continue;
            boolean bl2 = lastIsLowercaseLetter = Character.isLetter(lastChar) && Character.isLowerCase(lastChar);
            if (lastIsLowercaseLetter) continue;
            if (i + 1 >= name.length()) {
                sb.append('.');
                continue;
            }
            char nextChar = name.charAt(i + 1);
            if ('-' == nextChar) {
                sb.append(".");
                continue;
            }
            if ('.' == nextChar) continue;
            boolean nextWordIsUppercase = true;
            for (int j = i + 1; j < name.length() && !Character.isWhitespace(furtherChar = name.charAt(j)) && furtherChar != '-' && furtherChar != '~' && furtherChar != '.'; ++j) {
                boolean furtherIsUppercaseLetter;
                boolean bl3 = furtherIsUppercaseLetter = Character.isLetter(furtherChar) && Character.isUpperCase(furtherChar);
                if (furtherIsUppercaseLetter) continue;
                nextWordIsUppercase = false;
                break;
            }
            if (!nextWordIsUppercase) continue;
            sb.append(". ");
        }
        return sb.toString().trim();
    }

    public int hashCode() {
        return Objects.hash(this.firstAbbr, this.firstPart, this.jrPart, this.lastPart, this.vonPart);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Author) {
            Author a = (Author)o;
            return Objects.equals(this.firstPart, a.firstPart) && Objects.equals(this.firstAbbr, a.firstAbbr) && Objects.equals(this.vonPart, a.vonPart) && Objects.equals(this.lastPart, a.lastPart) && Objects.equals(this.jrPart, a.jrPart);
        }
        return false;
    }

    private boolean properBrackets(String s) {
        int level = 0;
        block4: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '{': {
                    ++level;
                    continue block4;
                }
                case '}': {
                    if (--level != -1) continue block4;
                    return false;
                }
            }
        }
        return level == 0;
    }

    private String removeStartAndEndBraces(String name) {
        if (name == null) {
            return null;
        }
        if (!name.contains("{")) {
            return name;
        }
        String[] split = name.split(" ");
        StringBuilder b = new StringBuilder();
        for (String s : split) {
            if (s.length() > 2 && s.startsWith("{") && s.endsWith("}")) {
                String inner = s.substring(1, s.length() - 1);
                if (inner.contains("}")) {
                    if (this.properBrackets(inner)) {
                        s = inner;
                    }
                } else {
                    s = inner;
                }
            }
            b.append(s).append(' ');
        }
        b.deleteCharAt(b.length() - 1);
        String newName = b.toString();
        if (newName.startsWith("{") && newName.endsWith("}")) {
            String inner = newName.substring(1, newName.length() - 1);
            if (this.properBrackets(inner)) {
                return inner;
            }
            return newName;
        }
        return newName;
    }

    public Optional<String> getFirst() {
        return Optional.ofNullable(this.firstPart);
    }

    public Optional<String> getFirstAbbr() {
        return Optional.ofNullable(this.firstAbbr);
    }

    public Optional<String> getVon() {
        return Optional.ofNullable(this.vonPart);
    }

    public Optional<String> getLast() {
        return Optional.ofNullable(this.lastPart);
    }

    public Optional<String> getJr() {
        return Optional.ofNullable(this.jrPart);
    }

    public String getLastOnly() {
        if (this.vonPart == null) {
            return this.getLast().orElse("");
        }
        return this.lastPart == null ? this.vonPart : this.vonPart + ' ' + this.lastPart;
    }

    public String getLastFirst(boolean abbr) {
        StringBuilder res = new StringBuilder(this.getLastOnly());
        this.getJr().ifPresent(jr -> res.append(", ").append((String)jr));
        if (abbr) {
            this.getFirstAbbr().ifPresent(firstA -> res.append(", ").append((String)firstA));
        } else {
            this.getFirst().ifPresent(first -> res.append(", ").append((String)first));
        }
        return res.toString();
    }

    public String getFirstLast(boolean abbr) {
        StringBuilder res = new StringBuilder();
        if (abbr) {
            this.getFirstAbbr().map(firstA -> firstA + ' ').ifPresent(res::append);
        } else {
            this.getFirst().map(first -> first + ' ').ifPresent(res::append);
        }
        res.append(this.getLastOnly());
        this.getJr().ifPresent(jr -> res.append(", ").append((String)jr));
        return res.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Author{");
        sb.append("firstPart='").append(this.firstPart).append('\'');
        sb.append(", firstAbbr='").append(this.firstAbbr).append('\'');
        sb.append(", vonPart='").append(this.vonPart).append('\'');
        sb.append(", lastPart='").append(this.lastPart).append('\'');
        sb.append(", jrPart='").append(this.jrPart).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public String getNameForAlphabetization() {
        StringBuilder res = new StringBuilder();
        this.getLast().ifPresent(res::append);
        this.getJr().ifPresent(jr -> res.append(", ").append((String)jr));
        this.getFirstAbbr().ifPresent(firstA -> res.append(", ").append((String)firstA));
        while (res.length() > 0 && res.charAt(0) == '{') {
            res.deleteCharAt(0);
        }
        return res.toString();
    }
}

