/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.model.database;

import com.google.common.eventbus.Subscribe;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.sf.jabref.model.database.event.EntryAddedEvent;
import net.sf.jabref.model.database.event.EntryRemovedEvent;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.event.FieldChangedEvent;

public class DuplicationChecker {
    private final Map<String, Integer> allKeys = new HashMap<String, Integer>();

    public boolean isDuplicateCiteKeyExisting(String citeKey) {
        return this.getNumberOfKeyOccurrences(citeKey) > 1;
    }

    public boolean isDuplicateCiteKeyExisting(BibEntry entry) {
        return this.isDuplicateCiteKeyExisting((String)entry.getCiteKeyOptional().orElse(null));
    }

    public int getNumberOfKeyOccurrences(String citeKey) {
        return this.allKeys.getOrDefault(citeKey, 0);
    }

    private void addKeyToSet(String key) {
        if (key == null || key.isEmpty()) {
            return;
        }
        this.allKeys.put(key, this.getNumberOfKeyOccurrences(key) + 1);
    }

    private void removeKeyFromSet(String key) {
        if (key == null || key.isEmpty()) {
            return;
        }
        int numberOfKeyOccurrences = this.getNumberOfKeyOccurrences(key);
        if (numberOfKeyOccurrences > 1) {
            this.allKeys.put(key, numberOfKeyOccurrences - 1);
        } else {
            this.allKeys.remove(key);
        }
    }

    @Subscribe
    public void listen(FieldChangedEvent fieldChangedEvent) {
        if (fieldChangedEvent.getFieldName().equals("bibtexkey")) {
            this.removeKeyFromSet(fieldChangedEvent.getOldValue());
            this.addKeyToSet(fieldChangedEvent.getNewValue());
        }
    }

    @Subscribe
    public void listen(EntryRemovedEvent entryRemovedEvent) {
        Optional<String> citeKey = entryRemovedEvent.getBibEntry().getCiteKeyOptional();
        if (citeKey.isPresent()) {
            this.removeKeyFromSet(citeKey.get());
        }
    }

    @Subscribe
    public void listen(EntryAddedEvent entryAddedEvent) {
        Optional<String> citekey = entryAddedEvent.getBibEntry().getCiteKeyOptional();
        if (citekey.isPresent()) {
            this.addKeyToSet(citekey.get());
        }
    }
}

