/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.model.database;

import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.database.BibDatabaseMode;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.BibLatexEntryTypes;
import net.sf.jabref.model.entry.BibtexEntryTypes;
import net.sf.jabref.model.entry.EntryType;

public class BibDatabaseModeDetection {
    private static final List<EntryType> BIBTEX = BibtexEntryTypes.ALL;
    private static final List<EntryType> BIBLATEX = BibLatexEntryTypes.ALL;
    private static final List<String> EXCLUSIVE_BIBLATEX = BibDatabaseModeDetection.filterEntryTypesNames(BIBLATEX, BibDatabaseModeDetection.isNotIncludedIn(BIBTEX));

    public static BibDatabaseMode inferMode(BibDatabase database) {
        Stream<String> entryTypes = database.getEntries().stream().map(BibEntry::getType);
        if (entryTypes.anyMatch(type -> EXCLUSIVE_BIBLATEX.contains(type.toLowerCase(Locale.ENGLISH)))) {
            return BibDatabaseMode.BIBLATEX;
        }
        return BibDatabaseMode.BIBTEX;
    }

    private static List<String> filterEntryTypesNames(List<EntryType> types, Predicate<EntryType> predicate) {
        return types.stream().filter(predicate).map(type -> type.getName().toLowerCase()).collect(Collectors.toList());
    }

    private static Predicate<EntryType> isNotIncludedIn(List<EntryType> collection) {
        return entry -> collection.stream().noneMatch(c -> c.getName().equalsIgnoreCase(entry.getName()));
    }
}

