/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.model.database;

import java.util.Locale;

public enum BibDatabaseMode {
    BIBTEX,
    BIBLATEX;


    public String getFormattedName() {
        if (this == BIBTEX) {
            return "BibTeX";
        }
        return "BibLaTeX";
    }

    public BibDatabaseMode getOppositeMode() {
        if (this == BIBTEX) {
            return BIBLATEX;
        }
        return BIBTEX;
    }

    public static BibDatabaseMode fromPreference(boolean isBibLatex) {
        if (isBibLatex) {
            return BIBLATEX;
        }
        return BIBTEX;
    }

    public static BibDatabaseMode parse(String data) {
        return BibDatabaseMode.valueOf(data.toUpperCase(Locale.ENGLISH));
    }

    public String getAsString() {
        return this.getFormattedName().toLowerCase(Locale.ENGLISH);
    }
}

