/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.model.database;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.sf.jabref.model.Defaults;
import net.sf.jabref.model.bibtexkeypattern.GlobalBibtexKeyPattern;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.database.BibDatabaseMode;
import net.sf.jabref.model.database.BibDatabaseModeDetection;
import net.sf.jabref.model.database.DatabaseLocation;
import net.sf.jabref.model.metadata.FileDirectoryPreferences;
import net.sf.jabref.model.metadata.MetaData;
import net.sf.jabref.shared.DBMSSynchronizer;

public class BibDatabaseContext {
    private final BibDatabase database;
    private MetaData metaData;
    private final Defaults defaults;
    private File file;
    private DBMSSynchronizer dbmsSynchronizer;
    private DatabaseLocation location;

    public BibDatabaseContext() {
        this(new Defaults());
    }

    public BibDatabaseContext(Defaults defaults) {
        this(new BibDatabase(), defaults);
    }

    public BibDatabaseContext(BibDatabase database) {
        this(database, new Defaults());
    }

    public BibDatabaseContext(BibDatabase database, Defaults defaults) {
        this(database, new MetaData(), defaults);
    }

    public BibDatabaseContext(BibDatabase database, MetaData metaData, Defaults defaults) {
        this.defaults = Objects.requireNonNull(defaults);
        this.database = Objects.requireNonNull(database);
        this.metaData = Objects.requireNonNull(metaData);
        this.location = DatabaseLocation.LOCAL;
    }

    public BibDatabaseContext(BibDatabase database, MetaData metaData) {
        this(database, metaData, new Defaults());
    }

    public BibDatabaseContext(BibDatabase database, MetaData metaData, File file, Defaults defaults, DatabaseLocation location) {
        this(database, metaData, defaults);
        Objects.requireNonNull(location);
        this.setDatabaseFile(file);
        if (location == DatabaseLocation.LOCAL) {
            this.convertToLocalDatabase();
        }
    }

    public BibDatabaseContext(BibDatabase database, MetaData metaData, File file, Defaults defaults) {
        this(database, metaData, file, defaults, DatabaseLocation.LOCAL);
    }

    public BibDatabaseContext(BibDatabase database, MetaData metaData, File file) {
        this(database, metaData, file, new Defaults());
    }

    public BibDatabaseContext(Defaults defaults, DatabaseLocation location, Character keywordSeparator, GlobalBibtexKeyPattern globalCiteKeyPattern) {
        this(new BibDatabase(), new MetaData(), defaults);
        if (location == DatabaseLocation.SHARED) {
            this.convertToSharedDatabase(keywordSeparator, globalCiteKeyPattern);
        }
    }

    public BibDatabaseMode getMode() {
        Optional<BibDatabaseMode> mode = this.metaData.getMode();
        if (!mode.isPresent()) {
            BibDatabaseMode inferredMode = BibDatabaseModeDetection.inferMode(this.database);
            BibDatabaseMode newMode = BibDatabaseMode.BIBTEX;
            if (this.defaults.mode == BibDatabaseMode.BIBLATEX || inferredMode == BibDatabaseMode.BIBLATEX) {
                newMode = BibDatabaseMode.BIBLATEX;
            }
            this.setMode(newMode);
            return newMode;
        }
        return mode.get();
    }

    public void setMode(BibDatabaseMode bibDatabaseMode) {
        this.metaData.setMode(bibDatabaseMode);
    }

    public Optional<File> getDatabaseFile() {
        return Optional.ofNullable(this.file);
    }

    public void setDatabaseFile(File file) {
        this.file = file;
    }

    public void clearDatabaseFile() {
        this.file = null;
    }

    public BibDatabase getDatabase() {
        return this.database;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(MetaData metaData) {
        this.metaData = Objects.requireNonNull(metaData);
    }

    public boolean isBiblatexMode() {
        return this.getMode() == BibDatabaseMode.BIBLATEX;
    }

    public List<String> getFileDirectory(FileDirectoryPreferences preferences) {
        return this.getFileDirectory("file", preferences);
    }

    public List<String> getFileDirectory(String fieldName, FileDirectoryPreferences preferences) {
        Optional<String> metaDataDirectory;
        ArrayList<String> fileDirs = new ArrayList<String>();
        Optional<String> userFileDirectory = this.metaData.getUserFileDirectory(preferences.getUser());
        if (userFileDirectory.isPresent()) {
            fileDirs.add(this.getFileDirectoryPath(userFileDirectory.get()));
        }
        if ((metaDataDirectory = this.metaData.getDefaultFileDirectory()).isPresent()) {
            fileDirs.add(this.getFileDirectoryPath(metaDataDirectory.get()));
        }
        preferences.getFileDirectory(fieldName).ifPresent(fileDirs::add);
        this.getDatabaseFile().ifPresent(databaseFile -> {
            String parentDir = databaseFile.getParent();
            if (preferences.isBibLocationAsPrimary()) {
                fileDirs.add(0, parentDir);
            } else {
                fileDirs.add(parentDir);
            }
        });
        return fileDirs;
    }

    private String getFileDirectoryPath(String directoryName) {
        String relDir;
        String dir = directoryName;
        Optional<File> databaseFile = this.getDatabaseFile();
        if (!new File(dir).isAbsolute() && databaseFile.isPresent() && new File(relDir = ".".equals(dir) ? databaseFile.get().getParent() : databaseFile.get().getParent() + File.separator + dir).exists()) {
            dir = relDir;
        }
        return dir;
    }

    public DBMSSynchronizer getDBMSSynchronizer() {
        return this.dbmsSynchronizer;
    }

    public void clearDBMSSynchronizer() {
        this.dbmsSynchronizer = null;
    }

    public DatabaseLocation getLocation() {
        return this.location;
    }

    public void convertToSharedDatabase(Character keywordSeparator, GlobalBibtexKeyPattern globalCiteKeyPattern) {
        this.dbmsSynchronizer = new DBMSSynchronizer(this, keywordSeparator, globalCiteKeyPattern);
        this.database.registerListener(this.dbmsSynchronizer);
        this.metaData.registerListener(this.dbmsSynchronizer);
        this.location = DatabaseLocation.SHARED;
    }

    public void convertToLocalDatabase() {
        if (Objects.nonNull(this.dbmsSynchronizer) && this.location == DatabaseLocation.SHARED) {
            this.database.unregisterListener(this.dbmsSynchronizer);
            this.metaData.unregisterListener(this.dbmsSynchronizer);
        }
        this.location = DatabaseLocation.LOCAL;
    }
}

