/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.model.cleanup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.sf.jabref.model.FieldChange;
import net.sf.jabref.model.cleanup.CleanupJob;
import net.sf.jabref.model.cleanup.Formatter;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.FieldName;
import net.sf.jabref.model.entry.event.EntryEventSource;

public class FieldFormatterCleanup
implements CleanupJob {
    private final String field;
    private final Formatter formatter;

    public FieldFormatterCleanup(String field, Formatter formatter) {
        this.field = field;
        this.formatter = formatter;
    }

    @Override
    public List<FieldChange> cleanup(BibEntry entry) {
        if ("all".equalsIgnoreCase(this.field)) {
            return this.cleanupAllFields(entry);
        }
        if ("all-text-fields".equalsIgnoreCase(this.field)) {
            return this.cleanupAllTextFields(entry);
        }
        return this.cleanupSingleField(this.field, entry);
    }

    private List<FieldChange> cleanupSingleField(String fieldKey, BibEntry entry) {
        String newValue;
        if (!entry.hasField(fieldKey)) {
            return new ArrayList<FieldChange>();
        }
        String oldValue = entry.getField(fieldKey).orElse(null);
        if (oldValue.equals(newValue = this.formatter.format(oldValue))) {
            return new ArrayList<FieldChange>();
        }
        if (newValue.isEmpty()) {
            entry.clearField(fieldKey);
            newValue = null;
        } else {
            entry.setField(fieldKey, newValue, EntryEventSource.SAVE_ACTION);
        }
        FieldChange change = new FieldChange(entry, fieldKey, oldValue, newValue);
        return Collections.singletonList(change);
    }

    private List<FieldChange> cleanupAllFields(BibEntry entry) {
        ArrayList<FieldChange> fieldChanges = new ArrayList<FieldChange>();
        for (String fieldKey : entry.getFieldNames()) {
            fieldChanges.addAll(this.cleanupSingleField(fieldKey, entry));
        }
        return fieldChanges;
    }

    private List<FieldChange> cleanupAllTextFields(BibEntry entry) {
        ArrayList<FieldChange> fieldChanges = new ArrayList<FieldChange>();
        Set<String> fields = entry.getFieldNames();
        fields.removeAll(FieldName.getNotTextFieldNames());
        for (String fieldKey : fields) {
            fieldChanges.addAll(this.cleanupSingleField(fieldKey, entry));
        }
        return fieldChanges;
    }

    public String getField() {
        return this.field;
    }

    public Formatter getFormatter() {
        return this.formatter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof FieldFormatterCleanup) {
            FieldFormatterCleanup that = (FieldFormatterCleanup)o;
            return Objects.equals(this.field, that.field) && Objects.equals(this.formatter, that.formatter);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.field, this.formatter);
    }

    public String toString() {
        return this.field + ": " + this.formatter.getName();
    }
}

