/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.model;

import java.util.Objects;
import net.sf.jabref.model.entry.BibEntry;

public class FieldChange {
    private final BibEntry entry;
    private final String field;
    private final String oldValue;
    private final String newValue;

    public FieldChange(BibEntry entry, String field, String oldValue, String newValue) {
        this.entry = entry;
        this.field = field;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public BibEntry getEntry() {
        return this.entry;
    }

    public String getField() {
        return this.field;
    }

    public String getOldValue() {
        return this.oldValue;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public int hashCode() {
        return Objects.hash(this.entry, this.field, this.newValue, this.oldValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FieldChange) {
            FieldChange other = (FieldChange)obj;
            if (this.entry == null ? other.entry != null : !this.entry.equals(other.entry)) {
                return false;
            }
            if (this.field == null ? other.field != null : !this.field.equals(other.field)) {
                return false;
            }
            if (this.newValue == null ? other.newValue != null : !this.newValue.equals(other.newValue)) {
                return false;
            }
            return !(this.oldValue == null ? other.oldValue != null : !this.oldValue.equals(other.oldValue));
        }
        return false;
    }

    public String toString() {
        return "FieldChange [entry=" + this.entry.getCiteKeyOptional().orElse("") + ", field=" + this.field + ", oldValue=" + this.oldValue + ", newValue=" + this.newValue + "]";
    }
}

