/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import net.sf.jabref.model.database.BibDatabaseMode;
import net.sf.jabref.model.entry.BibLatexEntryTypes;
import net.sf.jabref.model.entry.BibtexEntryTypes;
import net.sf.jabref.model.entry.CustomEntryType;
import net.sf.jabref.model.entry.EntryType;
import net.sf.jabref.model.entry.IEEETranEntryTypes;

public class EntryTypes {
    public static final InternalEntryTypes BIBTEX = new InternalEntryTypes(BibtexEntryTypes.MISC, Arrays.asList(BibtexEntryTypes.ALL, IEEETranEntryTypes.ALL));
    public static final InternalEntryTypes BIBLATEX = new InternalEntryTypes(BibLatexEntryTypes.MISC, Arrays.asList(BibLatexEntryTypes.ALL));

    public static Optional<EntryType> getType(String name, BibDatabaseMode type) {
        return type == BibDatabaseMode.BIBLATEX ? BIBLATEX.getType(name) : BIBTEX.getType(name);
    }

    public static EntryType getTypeOrDefault(String name, BibDatabaseMode mode) {
        return mode == BibDatabaseMode.BIBLATEX ? BIBLATEX.getTypeOrDefault(name) : BIBTEX.getTypeOrDefault(name);
    }

    public static Optional<EntryType> getStandardType(String name, BibDatabaseMode mode) {
        return mode == BibDatabaseMode.BIBLATEX ? BIBLATEX.getStandardType(name) : BIBTEX.getStandardType(name);
    }

    public static void addOrModifyCustomEntryType(CustomEntryType customEntryType) {
        EntryTypes.addOrModifyEntryType(customEntryType);
    }

    private static void addOrModifyEntryType(EntryType name) {
        EntryTypes.BIBLATEX.addOrModifyEntryType(name);
        EntryTypes.BIBTEX.addOrModifyEntryType(name);
    }

    public static Set<String> getAllTypes(BibDatabaseMode type) {
        return type == BibDatabaseMode.BIBLATEX ? BIBLATEX.getAllTypes() : BIBTEX.getAllTypes();
    }

    public static Collection<EntryType> getAllValues(BibDatabaseMode type) {
        return type == BibDatabaseMode.BIBLATEX ? BIBLATEX.getAllValues() : BIBTEX.getAllValues();
    }

    public static void removeType(String name, BibDatabaseMode type) {
        if (type == BibDatabaseMode.BIBLATEX) {
            BIBLATEX.removeType(name);
        } else {
            BIBTEX.removeType(name);
        }
    }

    public static void removeAllCustomEntryTypes() {
        for (BibDatabaseMode type : BibDatabaseMode.values()) {
            for (String typeName : new HashSet<String>(EntryTypes.getAllTypes(type))) {
                EntryTypes.getType(typeName, type).ifPresent(entryType -> {
                    if (entryType instanceof CustomEntryType) {
                        EntryTypes.removeType(typeName, type);
                    }
                });
            }
        }
    }

    private static class InternalEntryTypes {
        private final Map<String, EntryType> ALL_TYPES = new TreeMap<String, EntryType>();
        private final Map<String, EntryType> STANDARD_TYPES;
        private final EntryType defaultType;

        public InternalEntryTypes(EntryType defaultType, List<List<EntryType>> entryTypes) {
            this.defaultType = defaultType;
            for (List<EntryType> list : entryTypes) {
                for (EntryType type : list) {
                    this.ALL_TYPES.put(type.getName().toLowerCase(), type);
                }
            }
            this.STANDARD_TYPES = new TreeMap<String, EntryType>(this.ALL_TYPES);
        }

        public Optional<EntryType> getType(String name) {
            return Optional.ofNullable(this.ALL_TYPES.get(name.toLowerCase()));
        }

        public EntryType getTypeOrDefault(String type) {
            return this.getType(type).orElse(this.defaultType);
        }

        public Optional<EntryType> getStandardType(String name) {
            return Optional.ofNullable(this.STANDARD_TYPES.get(name.toLowerCase()));
        }

        private void addOrModifyEntryType(EntryType type) {
            this.ALL_TYPES.put(type.getName().toLowerCase(), type);
        }

        public Set<String> getAllTypes() {
            return this.ALL_TYPES.keySet();
        }

        public Collection<EntryType> getAllValues() {
            return this.ALL_TYPES.values();
        }

        public void removeType(String name) {
            String toLowerCase = name.toLowerCase();
            if (!this.ALL_TYPES.get(toLowerCase).equals(this.STANDARD_TYPES.get(toLowerCase))) {
                this.ALL_TYPES.remove(toLowerCase);
                if (this.STANDARD_TYPES.containsKey(toLowerCase)) {
                    this.addOrModifyEntryType(this.STANDARD_TYPES.get(toLowerCase));
                }
            }
        }
    }
}

