/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.sf.jabref.model.EntryTypes;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.database.BibDatabaseMode;
import net.sf.jabref.model.entry.AuthorList;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.EntryType;
import net.sf.jabref.model.entry.FieldProperty;
import net.sf.jabref.model.entry.InternalBibtexFields;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DuplicateCheck {
    private static final Log LOGGER = LogFactory.getLog(DuplicateCheck.class);
    private static final int NOT_EQUAL = 0;
    private static final int EQUAL = 1;
    private static final int EMPTY_IN_ONE = 2;
    private static final int EMPTY_IN_TWO = 3;
    private static final int EMPTY_IN_BOTH = 4;
    public static double duplicateThreshold = 0.75;
    private static final double DOUBT_RANGE = 0.05;
    private static final double REQUIRED_WEIGHT = 3.0;
    private static final Map<String, Double> FIELD_WEIGHTS = new HashMap<String, Double>();

    public static boolean isDuplicate(BibEntry one, BibEntry two, BibDatabaseMode bibDatabaseMode) {
        if (!one.getType().equals(two.getType())) {
            return false;
        }
        EntryType type = EntryTypes.getTypeOrDefault(one.getType(), bibDatabaseMode);
        List<String> var = type.getRequiredFieldsFlat();
        double[] req = var == null ? new double[]{0.0, 0.0} : DuplicateCheck.compareFieldSet(var, one, two);
        if (Math.abs(req[0] - duplicateThreshold) > 0.05) {
            return req[0] >= duplicateThreshold;
        }
        List<String> optionalFields = type.getOptionalFields();
        if (optionalFields != null) {
            double[] opt = DuplicateCheck.compareFieldSet(optionalFields, one, two);
            double totValue = (3.0 * req[0] * req[1] + opt[0] * opt[1]) / (req[1] * 3.0 + opt[1]);
            return totValue >= duplicateThreshold;
        }
        return req[0] >= duplicateThreshold;
    }

    private static double[] compareFieldSet(List<String> fields, BibEntry one, BibEntry two) {
        double res = 0.0;
        double totWeights = 0.0;
        for (String field : fields) {
            double weight = FIELD_WEIGHTS.containsKey(field) ? FIELD_WEIGHTS.get(field) : 1.0;
            totWeights += weight;
            int result = DuplicateCheck.compareSingleField(field, one, two);
            if (result == 1) {
                res += weight;
                continue;
            }
            if (result != 4) continue;
            totWeights -= weight;
        }
        if (totWeights > 0.0) {
            return new double[]{res / totWeights, totWeights};
        }
        return new double[]{0.5, 0.0};
    }

    private static int compareSingleField(String field, BibEntry one, BibEntry two) {
        Optional<String> optionalStringOne = one.getField(field);
        Optional<String> optionalStringTwo = two.getField(field);
        if (!optionalStringOne.isPresent()) {
            if (!optionalStringTwo.isPresent()) {
                return 4;
            }
            return 2;
        }
        if (!optionalStringTwo.isPresent()) {
            return 3;
        }
        String stringOne = optionalStringOne.get();
        String stringTwo = optionalStringTwo.get();
        if (InternalBibtexFields.getFieldProperties(field).contains((Object)FieldProperty.PERSON_NAMES)) {
            String authorTwo;
            String authorOne = AuthorList.fixAuthorLastNameOnlyCommas(stringOne, false).replace(" and ", " ").toLowerCase();
            double similarity = DuplicateCheck.correlateByWords(authorOne, authorTwo = AuthorList.fixAuthorLastNameOnlyCommas(stringTwo, false).replace(" and ", " ").toLowerCase());
            if (similarity > 0.8) {
                return 1;
            }
            return 0;
        }
        if ("pages".equals(field)) {
            if ((stringOne = stringOne.replaceAll("[- ]+", "-")).equals(stringTwo = stringTwo.replaceAll("[- ]+", "-"))) {
                return 1;
            }
            return 0;
        }
        if ("journal".equals(field)) {
            double similarity = DuplicateCheck.correlateByWords(stringOne = stringOne.replace(".", "").toLowerCase(), stringTwo = stringTwo.replace(".", "").toLowerCase());
            if (similarity > 0.8) {
                return 1;
            }
            return 0;
        }
        double similarity = DuplicateCheck.correlateByWords(stringOne = stringOne.toLowerCase(), stringTwo = stringTwo.toLowerCase());
        if (similarity > 0.8) {
            return 1;
        }
        return 0;
    }

    public static double compareEntriesStrictly(BibEntry one, BibEntry two) {
        HashSet<String> allFields = new HashSet<String>();
        allFields.addAll(one.getFieldNames());
        allFields.addAll(two.getFieldNames());
        int score = 0;
        for (String field : allFields) {
            Optional<String> stringTwo;
            Optional<String> stringOne = one.getField(field);
            if (!stringOne.equals(stringTwo = two.getField(field))) continue;
            ++score;
        }
        if (score == allFields.size()) {
            return 1.01;
        }
        return (double)score / (double)allFields.size();
    }

    public static Optional<BibEntry> containsDuplicate(BibDatabase database, BibEntry entry, BibDatabaseMode bibDatabaseMode) {
        for (BibEntry other : database.getEntries()) {
            if (!DuplicateCheck.isDuplicate(entry, other, bibDatabaseMode)) continue;
            return Optional.of(other);
        }
        return Optional.empty();
    }

    public static double correlateByWords(String s1, String s2) {
        String[] w1 = s1.split("\\s");
        String[] w2 = s2.split("\\s");
        int n = Math.min(w1.length, w2.length);
        int misses = 0;
        for (int i = 0; i < n; ++i) {
            double corr = DuplicateCheck.similarity(w1[i], w2[i]);
            if (!(corr < 0.75)) continue;
            ++misses;
        }
        double missRate = (double)misses / (double)n;
        return 1.0 - missRate;
    }

    private static double similarity(String s1, String s2) {
        int longerLength;
        String longer = s1;
        String shorter = s2;
        if (s1.length() < s2.length()) {
            longer = s2;
            shorter = s1;
        }
        if ((longerLength = longer.length()) == 0) {
            return 1.0;
        }
        double sim = (double)(longerLength - DuplicateCheck.editDistance(longer, shorter)) / (double)longerLength;
        LOGGER.debug("Longer string: " + longer + " Shorter string: " + shorter + " Similarity: " + sim);
        return sim;
    }

    private static int editDistance(String s1, String s2) {
        String s1LowerCase = s1.toLowerCase();
        String s2LowerCase = s2.toLowerCase();
        int[] costs = new int[s2LowerCase.length() + 1];
        for (int i = 0; i <= s1LowerCase.length(); ++i) {
            int lastValue = i;
            for (int j = 0; j <= s2LowerCase.length(); ++j) {
                if (i == 0) {
                    costs[j] = j;
                    continue;
                }
                if (j <= 0) continue;
                int newValue = costs[j - 1];
                if (s1LowerCase.charAt(i - 1) != s2LowerCase.charAt(j - 1)) {
                    newValue = Math.min(Math.min(newValue, lastValue), costs[j]) + 1;
                }
                costs[j - 1] = lastValue;
                lastValue = newValue;
            }
            if (i <= 0) continue;
            costs[s2LowerCase.length()] = lastValue;
        }
        LOGGER.debug("String 1: " + s1LowerCase + " String 2: " + s2LowerCase + " Distance: " + costs[s2LowerCase.length()]);
        return costs[s2LowerCase.length()];
    }

    static {
        FIELD_WEIGHTS.put("author", 2.5);
        FIELD_WEIGHTS.put("editor", 2.5);
        FIELD_WEIGHTS.put("title", 3.0);
        FIELD_WEIGHTS.put("journal", 2.0);
    }
}

