/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.migrations;

import java.util.HashMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefMain;
import net.sf.jabref.model.bibtexkeypattern.AbstractBibtexKeyPattern;
import net.sf.jabref.model.bibtexkeypattern.GlobalBibtexKeyPattern;
import net.sf.jabref.preferences.JabRefPreferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PreferencesMigrations {
    private static final Log LOGGER = LogFactory.getLog(PreferencesMigrations.class);

    public static void upgradeFaultyEncodingStrings() {
        JabRefPreferences prefs = Globals.prefs;
        String defaultEncoding = prefs.get("defaultEncoding");
        if (defaultEncoding == null) {
            return;
        }
        HashMap<String, String> encodingMap = new HashMap<String, String>();
        encodingMap.put("UTF8", "UTF-8");
        encodingMap.put("Cp1250", "CP1250");
        encodingMap.put("Cp1251", "CP1251");
        encodingMap.put("Cp1252", "CP1252");
        encodingMap.put("Cp1253", "CP1253");
        encodingMap.put("Cp1254", "CP1254");
        encodingMap.put("Cp1257", "CP1257");
        encodingMap.put("ISO8859_1", "ISO8859-1");
        encodingMap.put("ISO8859_2", "ISO8859-2");
        encodingMap.put("ISO8859_3", "ISO8859-3");
        encodingMap.put("ISO8859_4", "ISO8859-4");
        encodingMap.put("ISO8859_5", "ISO8859-5");
        encodingMap.put("ISO8859_6", "ISO8859-6");
        encodingMap.put("ISO8859_7", "ISO8859-7");
        encodingMap.put("ISO8859_8", "ISO8859-8");
        encodingMap.put("ISO8859_9", "ISO8859-9");
        encodingMap.put("ISO8859_13", "ISO8859-13");
        encodingMap.put("ISO8859_15", "ISO8859-15");
        encodingMap.put("KOI8_R", "KOI8-R");
        encodingMap.put("Big5_HKSCS", "Big5-HKSCS");
        encodingMap.put("EUC_JP", "EUC-JP");
        if (encodingMap.containsKey(defaultEncoding)) {
            prefs.put("defaultEncoding", (String)encodingMap.get(defaultEncoding));
        }
    }

    public static void upgradeSortOrder() {
        JabRefPreferences prefs = Globals.prefs;
        if (prefs.get("exportInSpecifiedOrder", null) == null) {
            if (prefs.getBoolean("exportInStandardOrder", false)) {
                prefs.putBoolean("exportInSpecifiedOrder", true);
                prefs.put("exportPriSort", "author");
                prefs.put("exportSecSort", "editor");
                prefs.put("exportTerSort", "year");
                prefs.putBoolean("exportPriDescending", false);
                prefs.putBoolean("exportSecDescending", false);
                prefs.putBoolean("exportTerDescending", false);
            } else if (prefs.getBoolean("exportInTitleOrder", false)) {
                prefs.putBoolean("exportInSpecifiedOrder", true);
                prefs.put("exportPriSort", "title");
                prefs.put("exportSecSort", "author");
                prefs.put("exportTerSort", "editor");
                prefs.putBoolean("exportPriDescending", false);
                prefs.putBoolean("exportSecDescending", false);
                prefs.putBoolean("exportTerDescending", false);
            }
        }
    }

    public static void upgradeLabelPatternToBibtexKeyPattern() {
        JabRefPreferences prefs = Globals.prefs;
        try {
            String oldDefault;
            Preferences mainPrefsNode = Preferences.userNodeForPackage(JabRefMain.class);
            if (mainPrefsNode.get("defaultBibtexKeyPattern", null) == null && (oldDefault = mainPrefsNode.get("defaultLabelPattern", null)) != null) {
                prefs.put("defaultBibtexKeyPattern", oldDefault);
                LOGGER.info("Upgraded old default key generator pattern '" + oldDefault + "' to new version.");
            }
            if (mainPrefsNode.nodeExists("bibtexkeypatterns")) {
                return;
            }
            if (mainPrefsNode.nodeExists("logic/labelpattern")) {
                PreferencesMigrations.migrateTypedKeyPrefs(prefs, mainPrefsNode.node("logic/labelpattern"));
            } else if (mainPrefsNode.nodeExists("logic/labelPattern")) {
                PreferencesMigrations.migrateTypedKeyPrefs(prefs, mainPrefsNode.node("logic/labelPattern"));
            } else if (mainPrefsNode.nodeExists("labelPattern")) {
                PreferencesMigrations.migrateTypedKeyPrefs(prefs, mainPrefsNode.node("labelPattern"));
            }
        }
        catch (BackingStoreException e) {
            LOGGER.error("Migrating old bibtexKeyPatterns failed.", e);
        }
    }

    private static void migrateTypedKeyPrefs(JabRefPreferences prefs, Preferences oldPatternPrefs) throws BackingStoreException {
        LOGGER.info("Found old Bibtex Key patterns which will be migrated to new version.");
        GlobalBibtexKeyPattern keyPattern = new GlobalBibtexKeyPattern(AbstractBibtexKeyPattern.split(prefs.get("defaultBibtexKeyPattern")));
        for (String key : oldPatternPrefs.keys()) {
            keyPattern.addBibtexKeyPattern(key, oldPatternPrefs.get(key, null));
        }
        prefs.putKeyPattern(keyPattern);
    }
}

