/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.migrations;

import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.FileDialog;
import net.sf.jabref.gui.entryeditor.EntryEditorTabList;
import net.sf.jabref.gui.importer.actions.PostOpenAction;
import net.sf.jabref.gui.undo.NamedCompound;
import net.sf.jabref.gui.undo.UndoableFieldChange;
import net.sf.jabref.logic.cleanup.UpgradePdfPsToFileCleanup;
import net.sf.jabref.logic.importer.ParserResult;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.FieldChange;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.entry.BibEntry;

public class FileLinksUpgradeWarning
implements PostOpenAction {
    private static final String[] FIELDS_TO_LOOK_FOR = new String[]{"pdf", "ps"};
    private boolean offerChangeSettings;
    private boolean offerChangeDatabase;
    private boolean offerSetFileDir;

    @Override
    public boolean isActionNecessary(ParserResult pr) {
        this.offerChangeSettings = !Globals.prefs.getBoolean("fileColumn") || !this.showsFileInGenFields();
        this.offerChangeDatabase = this.linksFound(pr.getDatabase(), FIELDS_TO_LOOK_FOR);
        this.offerSetFileDir = !Globals.prefs.hasKey("fileDirectory") && (Globals.prefs.hasKey("pdfDirectory") || Globals.prefs.hasKey("psDirectory"));
        return Globals.prefs.getBoolean("showFileLinksUpgradeWarning") && this.isThereSomethingToBeDone();
    }

    @Override
    public void performAction(BasePanel panel, ParserResult parserResult) {
        if (!this.isThereSomethingToBeDone()) {
            return;
        }
        JCheckBox changeSettings = new JCheckBox(Localization.lang("Change table column and General fields settings to use the new feature", new String[0]), this.offerChangeSettings);
        JCheckBox changeDatabase = new JCheckBox(Localization.lang("Upgrade old external file links to use the new feature", new String[0]), this.offerChangeDatabase);
        JCheckBox setFileDir = new JCheckBox(Localization.lang("Set main external file directory", new String[0]) + ":", this.offerSetFileDir);
        JTextField fileDir = new JTextField(30);
        JCheckBox doNotShowDialog = new JCheckBox(Localization.lang("Do not show these options in the future", new String[0]), false);
        JPanel message = new JPanel();
        FormBuilder formBuilder = FormBuilder.create().layout(new FormLayout("left:pref", "p"));
        int row = 1;
        formBuilder.add(new JLabel("<html>" + Localization.lang("This database uses outdated file links.", new String[0]) + "<br><br>" + Localization.lang("JabRef no longer supports 'ps' or 'pdf' fields.<br>File links are now stored in the 'file' field and files are stored in an external file directory.<br>To make use of this feature, JabRef needs to upgrade file links.<br><br>", new String[0]) + "<p>" + Localization.lang("Do you want JabRef to do the following operations?", new String[0]) + "</html>")).xy(1, row);
        if (this.offerChangeSettings) {
            formBuilder.appendRows("2dlu, p", new Object[0]);
            formBuilder.add(changeSettings).xy(1, row += 2);
        }
        if (this.offerChangeDatabase) {
            formBuilder.appendRows("2dlu, p", new Object[0]);
            formBuilder.add(changeDatabase).xy(1, row += 2);
        }
        if (this.offerSetFileDir) {
            if (Globals.prefs.hasKey("pdfDirectory")) {
                fileDir.setText(Globals.prefs.get("pdfDirectory"));
            } else {
                fileDir.setText(Globals.prefs.get("psDirectory"));
            }
            JPanel builderPanel = new JPanel();
            builderPanel.add(setFileDir);
            builderPanel.add(fileDir);
            JButton browse = new JButton(Localization.lang("Browse", new String[0]));
            browse.addActionListener(e -> new FileDialog(null).showDialogAndGetSelectedFile().ifPresent(f -> fileDir.setText(f.toAbsolutePath().toString())));
            builderPanel.add(browse);
            formBuilder.appendRows("2dlu, p", new Object[0]);
            formBuilder.add(builderPanel).xy(1, row += 2);
        }
        formBuilder.appendRows("6dlu, p", new Object[0]);
        formBuilder.add(doNotShowDialog).xy(1, row + 2);
        message.add(formBuilder.build());
        int answer = JOptionPane.showConfirmDialog(panel.frame(), message, Localization.lang("Upgrade file", new String[0]), 0);
        if (doNotShowDialog.isSelected()) {
            Globals.prefs.putBoolean("showFileLinksUpgradeWarning", false);
        }
        if (answer == 0) {
            this.makeChanges(panel, parserResult, changeSettings.isSelected(), changeDatabase.isSelected(), setFileDir.isSelected() ? fileDir.getText() : null);
        }
    }

    private boolean isThereSomethingToBeDone() {
        return this.offerChangeSettings || this.offerChangeDatabase || this.offerSetFileDir;
    }

    private boolean linksFound(BibDatabase database, String[] fields) {
        for (BibEntry entry : database.getEntries()) {
            for (String field : fields) {
                if (!entry.hasField(field)) continue;
                return true;
            }
        }
        return false;
    }

    private void makeChanges(BasePanel panel, ParserResult pr, boolean upgradePrefs, boolean upgradeDatabase, String fileDir) {
        if (upgradeDatabase) {
            NamedCompound ce = FileLinksUpgradeWarning.upgradePdfPsToFile(pr.getDatabase());
            panel.getUndoManager().addEdit(ce);
            panel.markBaseChanged();
        }
        if (fileDir != null) {
            Globals.prefs.put("fileDirectory", fileDir);
        }
        if (upgradePrefs) {
            Globals.prefs.putBoolean("fileColumn", Boolean.TRUE);
            if (!this.showsFileInGenFields()) {
                String gfs = Globals.prefs.get("customTabFields_0");
                StringBuilder sb = new StringBuilder(gfs);
                if (!gfs.isEmpty()) {
                    sb.append(';');
                }
                sb.append("file");
                Globals.prefs.put("customTabFields_0", sb.toString());
                Globals.prefs.updateEntryEditorTabList();
            }
            panel.frame().setupAllTables();
        }
    }

    private boolean showsFileInGenFields() {
        boolean found = false;
        EntryEditorTabList tabList = Globals.prefs.getEntryEditorTabList();
        block0: for (int i = 0; i < tabList.getTabCount(); ++i) {
            List<String> fields = tabList.getTabFields(i);
            for (String field : fields) {
                if (!field.equals("file")) continue;
                found = true;
                break block0;
            }
        }
        return found;
    }

    private static NamedCompound upgradePdfPsToFile(BibDatabase database) {
        NamedCompound ce = new NamedCompound(Localization.lang("Move external links to 'file' field", new String[0]));
        UpgradePdfPsToFileCleanup cleanupJob = new UpgradePdfPsToFileCleanup();
        for (BibEntry entry : database.getEntries()) {
            List<FieldChange> changes = cleanupJob.cleanup(entry);
            for (FieldChange change : changes) {
                ce.addEdit(new UndoableFieldChange(change));
            }
        }
        ce.end();
        return ce;
    }
}

