/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.xmp;

import java.io.IOException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.jabref.logic.xmp.XMPPreferences;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.entry.Author;
import net.sf.jabref.model.entry.AuthorList;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.FieldProperty;
import net.sf.jabref.model.entry.IdGenerator;
import net.sf.jabref.model.entry.InternalBibtexFields;
import org.apache.jempbox.xmp.XMPMetadata;
import org.apache.jempbox.xmp.XMPSchema;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMPSchemaBibtex
extends XMPSchema {
    public static final String NAMESPACE = "http://jabref.sourceforge.net/bibteXMP/";
    private static final String KEY = "bibtex";
    private static final Set<String> PRESERVE_WHITE_SPACE = new HashSet<String>();

    public XMPSchemaBibtex(XMPMetadata parent) {
        super(parent, KEY, NAMESPACE);
    }

    public XMPSchemaBibtex(Element e, String namespace) {
        super(e, KEY);
    }

    private static String makeProperty(String propertyName) {
        return "bibtex:" + propertyName;
    }

    public List<String> getPersonList(String field) {
        return this.getSequenceList(field);
    }

    public void setPersonList(String field, String value) {
        AuthorList list = AuthorList.parse(value);
        for (Author author : list.getAuthors()) {
            this.addSequenceValue(field, author.getFirstLast(false));
        }
    }

    @Override
    public String getTextProperty(String field) {
        return super.getTextProperty(XMPSchemaBibtex.makeProperty(field));
    }

    @Override
    public void setTextProperty(String field, String value) {
        super.setTextProperty(XMPSchemaBibtex.makeProperty(field), value);
    }

    @Override
    public List<String> getBagList(String bagName) {
        return super.getBagList(XMPSchemaBibtex.makeProperty(bagName));
    }

    @Override
    public void removeBagValue(String bagName, String value) {
        super.removeBagValue(XMPSchemaBibtex.makeProperty(bagName), value);
    }

    @Override
    public void addBagValue(String bagName, String value) {
        super.addBagValue(XMPSchemaBibtex.makeProperty(bagName), value);
    }

    @Override
    public List<String> getSequenceList(String seqName) {
        return super.getSequenceList(XMPSchemaBibtex.makeProperty(seqName));
    }

    @Override
    public void removeSequenceValue(String seqName, String value) {
        super.removeSequenceValue(XMPSchemaBibtex.makeProperty(seqName), value);
    }

    @Override
    public void addSequenceValue(String seqName, String value) {
        super.addSequenceValue(XMPSchemaBibtex.makeProperty(seqName), value);
    }

    @Override
    public List<Calendar> getSequenceDateList(String seqName) throws IOException {
        return super.getSequenceDateList(XMPSchemaBibtex.makeProperty(seqName));
    }

    @Override
    public void removeSequenceDateValue(String seqName, Calendar date) {
        super.removeSequenceDateValue(XMPSchemaBibtex.makeProperty(seqName), date);
    }

    @Override
    public void addSequenceDateValue(String field, Calendar date) {
        super.addSequenceDateValue(XMPSchemaBibtex.makeProperty(field), date);
    }

    private static String getContents(NodeList seqList) {
        Element seqNode = (Element)seqList.item(0);
        StringBuffer seq = null;
        NodeList items = seqNode.getElementsByTagName("rdf:li");
        for (int j = 0; j < items.getLength(); ++j) {
            Element li = (Element)items.item(j);
            if (seq == null) {
                seq = new StringBuffer();
            } else {
                seq.append(" and ");
            }
            seq.append(XMPSchemaBibtex.getTextContent(li));
        }
        if (seq != null) {
            return seq.toString();
        }
        return null;
    }

    public static Map<String, String> getAllProperties(XMPSchema schema, String namespaceName) {
        NodeList nodes = schema.getElement().getChildNodes();
        HashMap<String, String> result = new HashMap<String, String>();
        if (nodes == null) {
            return result;
        }
        int n = nodes.getLength();
        for (int i = 0; i < n; ++i) {
            String nodeName;
            String[] stringArray;
            Node node = nodes.item(i);
            if (node.getNodeType() != 2 && node.getNodeType() != 1 || (stringArray = (nodeName = node.getNodeName()).split(":")).length != 2 || !stringArray[0].equals(namespaceName)) continue;
            NodeList seqList = ((Element)node).getElementsByTagName("rdf:Seq");
            if (seqList.getLength() > 0) {
                String seq = XMPSchemaBibtex.getContents(seqList);
                if (seq == null) continue;
                result.put(stringArray[1], seq);
                continue;
            }
            NodeList bagList = ((Element)node).getElementsByTagName("rdf:Bag");
            if (bagList.getLength() > 0) {
                String seq = XMPSchemaBibtex.getContents(bagList);
                if (seq == null) continue;
                result.put(stringArray[1], seq);
                continue;
            }
            result.put(stringArray[1], XMPSchemaBibtex.getTextContent(node));
        }
        NamedNodeMap attrs = schema.getElement().getAttributes();
        int m = attrs.getLength();
        for (int j = 0; j < m; ++j) {
            Node node = attrs.item(j);
            String nodeName = node.getNodeName();
            String[] split = nodeName.split(":");
            if (split.length != 2 || !split[0].equals(namespaceName)) continue;
            result.put(split[1], node.getNodeValue());
        }
        for (Map.Entry entry : result.entrySet()) {
            String key = (String)entry.getKey();
            if (PRESERVE_WHITE_SPACE.contains(key)) continue;
            entry.setValue(((String)entry.getValue()).replaceAll("\\s+", " ").trim());
        }
        return result;
    }

    public void setBibtexEntry(BibEntry entry, XMPPreferences xmpPreferences) {
        this.setBibtexEntry(entry, null, xmpPreferences);
    }

    public void setBibtexEntry(BibEntry entry, BibDatabase database, XMPPreferences xmpPreferences) {
        Set<String> fields = entry.getFieldNames();
        if (xmpPreferences != null && xmpPreferences.isUseXMPPrivacyFilter()) {
            TreeSet<String> filters = new TreeSet<String>(xmpPreferences.getXmpPrivacyFilter());
            fields.removeAll(filters);
        }
        for (String field : fields) {
            String value = BibDatabase.getResolvedField(field, entry, database).orElse("");
            if (InternalBibtexFields.getFieldProperties(field).contains((Object)FieldProperty.PERSON_NAMES)) {
                this.setPersonList(field, value);
                continue;
            }
            this.setTextProperty(field, value);
        }
        this.setTextProperty("entrytype", entry.getType());
    }

    public BibEntry getBibtexEntry() {
        String type = this.getTextProperty("entrytype");
        BibEntry e = new BibEntry(IdGenerator.next(), type);
        Map<String, String> text = XMPSchemaBibtex.getAllProperties(this, KEY);
        text.remove("entrytype");
        e.setField(text);
        return e;
    }

    public static String getTextContent(Node node) {
        boolean hasTextContent = false;
        StringBuilder buffer = new StringBuilder();
        NodeList nlist = node.getChildNodes();
        for (int i = 0; i < nlist.getLength(); ++i) {
            Node child = nlist.item(i);
            if (child.getNodeType() != 3) continue;
            buffer.append(child.getNodeValue());
            hasTextContent = true;
        }
        return hasTextContent ? buffer.toString() : "";
    }

    static {
        PRESERVE_WHITE_SPACE.add("abstract");
        PRESERVE_WHITE_SPACE.add("note");
        PRESERVE_WHITE_SPACE.add("review");
    }
}

