/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.util.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.logic.bibtexkeypattern.BibtexKeyPatternUtil;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.strings.StringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RegExpFileSearch {
    private static final Log LOGGER = LogFactory.getLog(RegExpFileSearch.class);
    private static final String EXT_MARKER = "__EXTENSION__";
    private static final Pattern ESCAPE_PATTERN = Pattern.compile("([^\\\\])\\\\([^\\\\])");
    private static final Pattern SQUARE_BRACKETS_PATTERN = Pattern.compile("\\[.*?\\]");

    public static Map<BibEntry, List<File>> findFilesForSet(List<BibEntry> entries, List<String> extensions, List<File> directories, String regExp, Character keywordDelimiter) {
        HashMap<BibEntry, List<File>> res = new HashMap<BibEntry, List<File>>();
        for (BibEntry entry : entries) {
            res.put(entry, RegExpFileSearch.findFiles(entry, extensions, directories, regExp, keywordDelimiter));
        }
        return res;
    }

    private static List<File> findFiles(BibEntry entry, List<String> extensions, List<File> directories, String regularExpression, Character keywordDelimiter) {
        String extensionRegExp = '(' + String.join((CharSequence)"|", extensions) + ')';
        return RegExpFileSearch.findFile(entry, directories, regularExpression, extensionRegExp, keywordDelimiter);
    }

    private static List<File> findFile(BibEntry entry, List<File> dirs, String file, String extensionRegExp, Character keywordDelimiter) {
        ArrayList<File> res = new ArrayList<File>();
        for (File directory : dirs) {
            res.addAll(RegExpFileSearch.findFile(entry, directory.getPath(), file, extensionRegExp, keywordDelimiter));
        }
        return res;
    }

    private static List<File> findFile(BibEntry entry, String directory, String file, String extensionRegExp, Character keywordDelimiter) {
        File root = directory == null ? new File(".") : new File(directory);
        if (!root.exists()) {
            return Collections.emptyList();
        }
        List<File> fileList = RegExpFileSearch.findFile(entry, root, file, extensionRegExp, keywordDelimiter);
        ArrayList<File> result = new ArrayList<File>();
        for (File tmpFile : fileList) {
            try {
                String tmp = tmpFile.getCanonicalPath().substring(root.getCanonicalPath().length());
                if (tmp.length() > 1 && tmp.charAt(0) == File.separatorChar) {
                    tmp = tmp.substring(1);
                }
                result.add(new File(tmp));
            }
            catch (IOException e) {
                LOGGER.warn("Problem searching", e);
            }
        }
        return result;
    }

    private static List<File> findFile(BibEntry entry, File directory, String file, String extensionRegExp, Character keywordDelimiter) {
        File actualDirectory;
        ArrayList<File> res = new ArrayList<File>();
        String fileName = file;
        if (fileName.startsWith("/")) {
            actualDirectory = new File(".");
            fileName = fileName.substring(1);
        } else {
            actualDirectory = directory;
        }
        Matcher m = ESCAPE_PATTERN.matcher(fileName);
        StringBuffer s = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(s, m.group(1) + '/' + m.group(2));
        }
        m.appendTail(s);
        fileName = s.toString();
        String[] fileParts = fileName.split("/");
        if (fileParts.length == 0) {
            return res;
        }
        for (int i = 0; i < fileParts.length - 1; ++i) {
            String restOfFileString;
            File[] subDirs;
            String dirToProcess = fileParts[i];
            if ((dirToProcess = RegExpFileSearch.expandBrackets(dirToProcess, entry, null, keywordDelimiter)).matches("^.:$")) {
                actualDirectory = new File(dirToProcess + '/');
                continue;
            }
            if (".".equals(dirToProcess)) continue;
            if ("..".equals(dirToProcess)) {
                actualDirectory = new File(actualDirectory.getParent());
                continue;
            }
            if ("*".equals(dirToProcess) && (subDirs = actualDirectory.listFiles()) != null) {
                restOfFileString = StringUtil.join(fileParts, "/", i + 1, fileParts.length);
                for (File subDir : subDirs) {
                    if (!subDir.isDirectory()) continue;
                    res.addAll(RegExpFileSearch.findFile(entry, subDir, restOfFileString, extensionRegExp, keywordDelimiter));
                }
            }
            if (!"**".equals(dirToProcess)) continue;
            LinkedList<File> toDo = new LinkedList<File>();
            toDo.add(actualDirectory);
            restOfFileString = StringUtil.join(fileParts, "/", i + 1, fileParts.length);
            while (!toDo.isEmpty()) {
                File[] subDirs2 = ((File)toDo.remove(0)).listFiles();
                if (subDirs2 == null) continue;
                toDo.addAll(Arrays.asList(subDirs2));
                for (File subDir : subDirs2) {
                    if (!subDir.isDirectory()) continue;
                    res.addAll(RegExpFileSearch.findFile(entry, subDir, restOfFileString, extensionRegExp, keywordDelimiter));
                }
            }
        }
        String filePart = fileParts[fileParts.length - 1].replace("[extension]", EXT_MARKER);
        String filenameToLookFor = RegExpFileSearch.expandBrackets(filePart, entry, null, keywordDelimiter).replaceAll(EXT_MARKER, extensionRegExp);
        Pattern toMatch = Pattern.compile('^' + filenameToLookFor.replaceAll("\\\\\\\\", "\\\\") + '$', 2);
        File[] matches = actualDirectory.listFiles((arg0, arg1) -> toMatch.matcher(arg1).matches());
        if (matches != null && matches.length > 0) {
            Collections.addAll(res, matches);
        }
        return res;
    }

    public static String expandBrackets(String bracketString, BibEntry entry, BibDatabase database, Character keywordDelimiter) {
        Matcher m = SQUARE_BRACKETS_PATTERN.matcher(bracketString);
        StringBuffer s = new StringBuffer();
        while (m.find()) {
            String replacement = RegExpFileSearch.getFieldAndFormat(m.group(), entry, database, keywordDelimiter);
            m.appendReplacement(s, replacement);
        }
        m.appendTail(s);
        return s.toString();
    }

    public static String getFieldAndFormat(String fieldAndFormat, BibEntry entry, BibDatabase database, Character keywordDelimiter) {
        String afterColon;
        String beforeColon;
        String strippedFieldAndFormat = StringUtil.stripBrackets(fieldAndFormat);
        int colon = strippedFieldAndFormat.indexOf(58);
        if (colon == -1) {
            beforeColon = strippedFieldAndFormat;
            afterColon = null;
        } else {
            beforeColon = strippedFieldAndFormat.substring(0, colon);
            afterColon = strippedFieldAndFormat.substring(colon + 1);
        }
        beforeColon = beforeColon.trim();
        if (beforeColon.isEmpty()) {
            return "";
        }
        String fieldValue = BibDatabase.getResolvedField(beforeColon, entry, database).orElse(BibtexKeyPatternUtil.makeLabel(entry, beforeColon, keywordDelimiter));
        if (fieldValue == null) {
            return "";
        }
        if (afterColon == null || afterColon.isEmpty()) {
            return fieldValue;
        }
        List<String> parts = Arrays.asList(afterColon.split(":"));
        fieldValue = BibtexKeyPatternUtil.applyModifiers(fieldValue, parts, 0);
        return fieldValue;
    }
}

