/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.util.io;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Pattern;
import net.sf.jabref.logic.layout.Layout;
import net.sf.jabref.logic.layout.LayoutFormatterPreferences;
import net.sf.jabref.logic.layout.LayoutHelper;
import net.sf.jabref.logic.util.OS;
import net.sf.jabref.logic.util.io.FileFinder;
import net.sf.jabref.logic.util.io.FileNameCleaner;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.database.BibDatabaseContext;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.FileField;
import net.sf.jabref.model.entry.ParsedFileField;
import net.sf.jabref.model.metadata.FileDirectoryPreferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileUtil {
    private static final Log LOGGER = LogFactory.getLog(FileUtil.class);
    private static final Pattern SLASH = Pattern.compile("/");
    private static final Pattern BACKSLASH = Pattern.compile("\\\\");

    public static Optional<String> getFileExtension(File file) {
        return FileUtil.getFileExtension(file.getName());
    }

    public static Optional<String> getFileExtension(String fileName) {
        int pos = fileName.lastIndexOf(46);
        if (pos > 0 && pos < fileName.length() - 1) {
            return Optional.of(fileName.substring(pos + 1).trim().toLowerCase());
        }
        return Optional.empty();
    }

    public static Path addExtension(Path path, String extension) {
        Path fileName = path.getFileName();
        return path.resolveSibling(fileName + extension);
    }

    public static List<String> uniquePathSubstrings(List<String> paths) {
        ArrayList stackList = new ArrayList(paths.size());
        for (String path : paths) {
            List<String> directories = Arrays.asList(path.split(Pattern.quote(File.separator)));
            Stack<String> stack = new Stack<String>();
            stack.addAll(directories);
            stackList.add(stack);
        }
        ArrayList<String> pathSubstrings = new ArrayList<String>(Collections.nCopies(paths.size(), ""));
        while (!stackList.stream().allMatch(Vector::isEmpty)) {
            String tempString;
            int i;
            for (i = 0; i < stackList.size(); ++i) {
                tempString = (String)pathSubstrings.get(i);
                if (tempString.isEmpty() && !((Stack)stackList.get(i)).isEmpty()) {
                    pathSubstrings.set(i, (String)((Stack)stackList.get(i)).pop());
                    continue;
                }
                if (((Stack)stackList.get(i)).isEmpty()) continue;
                pathSubstrings.set(i, (String)((Stack)stackList.get(i)).pop() + File.separator + tempString);
            }
            for (i = 0; i < stackList.size(); ++i) {
                tempString = (String)pathSubstrings.get(i);
                if (Collections.frequency(pathSubstrings, tempString) != 1) continue;
                ((Stack)stackList.get(i)).clear();
            }
        }
        return pathSubstrings;
    }

    public static boolean copyFile(Path pathToSourceFile, Path pathToDestinationFile, boolean replaceExisting) {
        if (!Files.exists(pathToSourceFile, new LinkOption[0])) {
            LOGGER.error("Path to the source file doesn't exist.");
            return false;
        }
        if (Files.exists(pathToDestinationFile, new LinkOption[0]) && !replaceExisting) {
            LOGGER.error("Path to the destination file is not exists and the file shouldn't be replace.");
            return false;
        }
        try {
            return Files.copy(pathToSourceFile, pathToDestinationFile, StandardCopyOption.REPLACE_EXISTING) != null;
        }
        catch (IOException e) {
            LOGGER.error("Copying Files failed.", e);
            return false;
        }
    }

    public static boolean renameFile(String fromFile, String toFile) {
        try {
            Path src = Paths.get(fromFile, new String[0]);
            return Files.move(src, src.resolveSibling(toFile), new CopyOption[0]) != null;
        }
        catch (IOException e) {
            LOGGER.error("Renaming Files failed", e);
            return false;
        }
    }

    public static Optional<File> expandFilename(BibDatabaseContext databaseContext, String name, FileDirectoryPreferences fileDirectoryPreferences) {
        Optional<String> extension = FileUtil.getFileExtension(name);
        List<String> directories = databaseContext.getFileDirectory(extension.orElse(null), fileDirectoryPreferences);
        List<String> fileDir = databaseContext.getFileDirectory(fileDirectoryPreferences);
        ArrayList<String> al = new ArrayList<String>();
        for (String dir : directories) {
            if (al.contains(dir)) continue;
            al.add(dir);
        }
        for (String aFileDir : fileDir) {
            if (al.contains(aFileDir)) continue;
            al.add(aFileDir);
        }
        return FileUtil.expandFilename(name, al);
    }

    public static Optional<File> expandFilename(String name, List<String> directories) {
        for (String dir : directories) {
            Optional<File> result;
            if (dir == null || !(result = FileUtil.expandFilename(name, dir)).isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    private static Optional<File> expandFilename(String filename, String dir) {
        if (filename == null || filename.isEmpty()) {
            return Optional.empty();
        }
        String name = filename;
        File file = new File(name);
        if (file.exists() || dir == null) {
            return Optional.of(file);
        }
        name = dir.endsWith(OS.FILE_SEPARATOR) ? dir + name : dir + OS.FILE_SEPARATOR + name;
        name = OS.WINDOWS ? SLASH.matcher(name).replaceAll("\\\\") : BACKSLASH.matcher(name).replaceAll("/");
        File fileInDir = new File(name);
        if (fileInDir.exists()) {
            return Optional.of(fileInDir);
        }
        return Optional.empty();
    }

    public static File shortenFileName(File fileName, List<String> dirs) {
        if (fileName == null || !fileName.isAbsolute() || dirs == null) {
            return fileName;
        }
        for (String dir : dirs) {
            File result;
            if (dir == null || (result = FileUtil.shortenFileName(fileName, dir)) == null || result.equals(fileName)) continue;
            return result;
        }
        return fileName;
    }

    private static File shortenFileName(File fileName, String directory) {
        String longName;
        if (fileName == null || !fileName.isAbsolute() || directory == null) {
            return fileName;
        }
        String dir = directory;
        if (OS.WINDOWS) {
            longName = fileName.toString().toLowerCase();
            dir = dir.toLowerCase();
        } else {
            longName = fileName.toString();
        }
        if (!dir.endsWith(OS.FILE_SEPARATOR)) {
            dir = dir.concat(OS.FILE_SEPARATOR);
        }
        if (longName.startsWith(dir)) {
            String newName = fileName.toString().substring(dir.length());
            return new File(newName);
        }
        return fileName;
    }

    public static Map<BibEntry, List<File>> findAssociatedFiles(List<BibEntry> entries, List<String> extensions, List<File> directories, boolean autolinkExactKeyOnly) {
        HashMap<BibEntry, List<File>> result = new HashMap<BibEntry, List<File>>();
        Set<File> filesWithExtension = FileFinder.findFiles(extensions, directories);
        for (BibEntry entry : entries) {
            result.put(entry, new ArrayList());
        }
        block1: for (File file : filesWithExtension) {
            Optional<String> citeKey;
            String name = file.getName();
            int dot = name.lastIndexOf(46);
            for (BibEntry entry : entries) {
                citeKey = entry.getCiteKeyOptional();
                if (!citeKey.isPresent() || citeKey.get().isEmpty() || dot <= 0 || !name.substring(0, dot).equals(citeKey.get())) continue;
                ((List)result.get(entry)).add(file);
                continue block1;
            }
            if (autolinkExactKeyOnly) continue;
            for (BibEntry entry : entries) {
                citeKey = entry.getCiteKeyOptional();
                if (!citeKey.isPresent() || citeKey.get().isEmpty() || !name.startsWith(citeKey.get())) continue;
                ((List)result.get(entry)).add(file);
                continue block1;
            }
        }
        return result;
    }

    public static List<File> getListOfLinkedFiles(List<BibEntry> bes, List<String> fileDirs) {
        Objects.requireNonNull(bes);
        Objects.requireNonNull(fileDirs);
        ArrayList<File> result = new ArrayList<File>();
        for (BibEntry entry : bes) {
            entry.getField("file").ifPresent(fileField -> {
                List<ParsedFileField> fileList = FileField.parse(fileField);
                for (ParsedFileField file : fileList) {
                    FileUtil.expandFilename(file.getLink(), fileDirs).ifPresent(result::add);
                }
            });
        }
        return result;
    }

    public static String createFileNameFromPattern(BibDatabase database, BibEntry entry, String fileNamePattern, LayoutFormatterPreferences prefs) {
        String targetName = null;
        StringReader sr = new StringReader(fileNamePattern);
        Layout layout = null;
        try {
            layout = new LayoutHelper(sr, prefs).getLayoutFromText();
        }
        catch (IOException e) {
            LOGGER.info("Wrong format " + e.getMessage(), e);
        }
        if (layout != null) {
            targetName = layout.doLayout(entry, database);
        }
        if (targetName == null || targetName.isEmpty()) {
            targetName = entry.getCiteKeyOptional().orElse("default");
        }
        targetName = FileNameCleaner.cleanFileName(targetName);
        return targetName;
    }
}

