/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.util.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sf.jabref.logic.util.io.FileUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileFinder {
    private static final Log LOGGER = LogFactory.getLog(FileFinder.class);

    public static Set<File> findFiles(List<String> extensions, List<File> directories) {
        Objects.requireNonNull(directories, "Directories must not be null!");
        Objects.requireNonNull(extensions, "Extensions must not be null!");
        BiPredicate<Path, BasicFileAttributes> isDirectoryAndContainsExtension = (path, attr) -> !Files.isDirectory(path, new LinkOption[0]) && extensions.contains(FileUtil.getFileExtension(path.toFile()).orElse(""));
        HashSet<File> result = new HashSet<File>();
        for (File directory : directories) {
            try {
                Stream<File> files = Files.find(directory.toPath(), Integer.MAX_VALUE, isDirectoryAndContainsExtension, new FileVisitOption[0]).map(x -> x.toFile());
                Throwable throwable = null;
                try {
                    result.addAll(files.collect(Collectors.toSet()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (files == null) continue;
                    if (throwable != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    files.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("Problem in finding files", e);
            }
        }
        return result;
    }
}

