/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.util.io;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.sf.jabref.logic.util.io.FileUtil;
import net.sf.jabref.model.database.BibDatabaseContext;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.FileField;
import net.sf.jabref.model.entry.ParsedFileField;
import net.sf.jabref.model.metadata.FileDirectoryPreferences;

public class DatabaseFileLookup {
    private final Set<File> fileCache = new HashSet<File>();
    private final List<String> possibleFilePaths;

    public DatabaseFileLookup(BibDatabaseContext databaseContext, FileDirectoryPreferences fileDirectoryPreferences) {
        Objects.requireNonNull(databaseContext);
        this.possibleFilePaths = Optional.ofNullable(databaseContext.getFileDirectory(fileDirectoryPreferences)).orElse(new ArrayList());
        for (BibEntry entry : databaseContext.getDatabase().getEntries()) {
            this.fileCache.addAll(this.parseFileField(entry));
        }
    }

    public boolean lookupDatabase(File file) {
        return this.fileCache.contains(file);
    }

    private List<File> parseFileField(BibEntry entry) {
        Objects.requireNonNull(entry);
        List<ParsedFileField> entries = FileField.parse(entry.getField("file").orElse(null));
        ArrayList<File> fileLinks = new ArrayList<File>();
        for (ParsedFileField field : entries) {
            String link = field.getLink();
            if (link.contains("//")) continue;
            FileUtil.expandFilename(link, this.possibleFilePaths).ifPresent(fileLinks::add);
        }
        return fileLinks;
    }
}

