/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.util.date;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class EasyDateFormat {
    private final DateTimeFormatter dateFormatter;

    public EasyDateFormat(String dateFormat) {
        this(DateTimeFormatter.ofPattern(dateFormat));
    }

    public EasyDateFormat(DateTimeFormatter dateFormatter) {
        this.dateFormatter = dateFormatter;
    }

    public String getCurrentDate() {
        return this.getDateAt(ZonedDateTime.now());
    }

    public String getDateAt(Date date) {
        return this.getDateAt(date.toInstant().atZone(ZoneId.systemDefault()));
    }

    public String getDateAt(ZonedDateTime dateTime) {
        return dateTime.format(this.dateFormatter);
    }

    public static EasyDateFormat fromTimeStampFormat(String timeStampFormat) {
        return new EasyDateFormat(timeStampFormat);
    }

    public static EasyDateFormat isoDateFormat() {
        return new EasyDateFormat(DateTimeFormatter.ISO_LOCAL_DATE);
    }
}

