/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.util;

import java.util.Collection;
import java.util.Optional;
import net.sf.jabref.logic.util.UpdateFieldPreferences;
import net.sf.jabref.logic.util.date.EasyDateFormat;
import net.sf.jabref.model.FieldChange;
import net.sf.jabref.model.entry.BibEntry;

public class UpdateField {
    public static Optional<FieldChange> updateField(BibEntry be, String field, String newValue) {
        return UpdateField.updateField(be, field, newValue, false);
    }

    public static Optional<FieldChange> updateNonDisplayableField(BibEntry be, String field, String newValue) {
        boolean changed = be.hasChanged();
        Optional<FieldChange> fieldChange = UpdateField.updateField(be, field, newValue, false);
        be.setChanged(changed);
        return fieldChange;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Optional<FieldChange> updateField(BibEntry be, String field, String newValue, Boolean nullFieldIfValueIsTheSame) {
        String writtenValue = null;
        String oldValue = null;
        if (be.hasField(field)) {
            oldValue = be.getField(field).get();
            if (newValue == null || oldValue.equals(newValue) && nullFieldIfValueIsTheSame.booleanValue()) {
                be.clearField(field);
                return Optional.of(new FieldChange(be, field, oldValue, writtenValue));
            } else {
                if (oldValue.equals(newValue)) return Optional.empty();
                writtenValue = newValue;
                be.setField(field, newValue);
            }
            return Optional.of(new FieldChange(be, field, oldValue, writtenValue));
        } else {
            if (newValue == null) {
                return Optional.empty();
            }
            writtenValue = newValue;
            be.setField(field, newValue);
        }
        return Optional.of(new FieldChange(be, field, oldValue, writtenValue));
    }

    public static void setAutomaticFields(BibEntry entry, boolean overwriteOwner, boolean overwriteTimestamp, UpdateFieldPreferences prefs) {
        String defaultOwner = prefs.getDefaultOwner();
        String timestamp = EasyDateFormat.fromTimeStampFormat(prefs.getTimeStampFormat()).getCurrentDate();
        String timeStampField = prefs.getTimeStampField();
        boolean setOwner = prefs.isUseOwner() && (overwriteOwner || !entry.hasField("owner"));
        boolean setTimeStamp = prefs.isUseTimeStamp() && (overwriteTimestamp || !entry.hasField(timeStampField));
        UpdateField.setAutomaticFields(entry, setOwner, defaultOwner, setTimeStamp, timeStampField, timestamp);
    }

    public static void setAutomaticFields(BibEntry entry, UpdateFieldPreferences prefs) {
        UpdateField.setAutomaticFields(entry, prefs.isOverwriteOwner(), prefs.isOverwriteTimeStamp(), prefs);
    }

    private static void setAutomaticFields(BibEntry entry, boolean setOwner, String owner, boolean setTimeStamp, String timeStampField, String timeStamp) {
        if (setOwner) {
            entry.setField("owner", owner);
        }
        if (setTimeStamp) {
            entry.setField(timeStampField, timeStamp);
        }
    }

    public static void setAutomaticFields(Collection<BibEntry> bibs, boolean overwriteOwner, boolean overwriteTimestamp, UpdateFieldPreferences prefs) {
        boolean globalSetOwner = prefs.isUseOwner();
        boolean globalSetTimeStamp = prefs.isUseTimeStamp();
        if (!globalSetOwner && !globalSetTimeStamp) {
            return;
        }
        String timeStampField = prefs.getTimeStampField();
        String defaultOwner = prefs.getDefaultOwner();
        String timestamp = EasyDateFormat.fromTimeStampFormat(prefs.getTimeStampFormat()).getCurrentDate();
        for (BibEntry curEntry : bibs) {
            boolean setOwner = globalSetOwner && (overwriteOwner || !curEntry.hasField("owner"));
            boolean setTimeStamp = globalSetTimeStamp && (overwriteTimestamp || !curEntry.hasField(timeStampField));
            UpdateField.setAutomaticFields(curEntry, setOwner, defaultOwner, setTimeStamp, timeStampField, timestamp);
        }
    }

    public static void setAutomaticFields(Collection<BibEntry> bibs, UpdateFieldPreferences prefs) {
        UpdateField.setAutomaticFields(bibs, prefs.isOverwriteOwner(), prefs.isOverwriteTimeStamp(), prefs);
    }
}

