/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.util;

import java.util.StringJoiner;
import net.sf.jabref.logic.l10n.Localization;

public enum FileExtensions {
    BIBTEX_DB(String.format("%1s %2s", "BibTex", Localization.lang("Database", new String[0])), "bib"),
    BIBTEXML(Localization.lang("%0 file", "BibTeXML"), "bibx", "xml"),
    BILBIOSCAPE(Localization.lang("%0 file", "Biblioscape"), "txt"),
    COPAC(Localization.lang("%0 file", "Copac"), "txt"),
    CITATION_STYLE(Localization.lang("%0 file", "CSL"), "csl"),
    ENDNOTE(Localization.lang("%0 file", "Endnote/Refer"), "ref", "enw"),
    FREECITE(Localization.lang("%0 file", "FreeCite"), "txt", "xml"),
    INSPEC(Localization.lang("%0 file", "INSPEC"), "txt"),
    ISI(Localization.lang("%0 file", "ISI"), "isi", "txt"),
    MEDLINE(Localization.lang("%0 file", "Medline"), "nbib", "xml"),
    MEDLINE_PLAIN(Localization.lang("%0 file", "MedlinePlain"), "nbib", "txt"),
    MODS(Localization.lang("%0 file", "MODS"), "xml"),
    MSBIB(Localization.lang("%0 file", "MSBib"), "xml"),
    OVID(Localization.lang("%0 file", "Ovid"), "txt"),
    PDF_CONTENT(Localization.lang("%0 file", "PDF content "), "pdf"),
    PUBMED(Localization.lang("%0 file", "PubMed"), "fcgi"),
    REPEC("REPEC New Economic Papers (NEP)", "txt"),
    RIS(Localization.lang("%0 file", "RIS"), "ris"),
    SILVER_PLATTER(Localization.lang("%0 file", "SilverPlatter"), "dat", "txt"),
    XMP(Localization.lang("XMP-annotated PDF", new String[0]), "pdf"),
    AUX(Localization.lang("%0 file", "AUX"), "aux"),
    JSTYLE(Localization.lang("Style file", new String[0]), "jstyle"),
    LAYOUT(Localization.lang("Custom layout file", new String[0]), "layout"),
    TERMS(Localization.lang("Protected terms file", new String[0]), "terms"),
    TXT(Localization.lang("%0 file", Localization.lang("Plain text", new String[0])), "txt"),
    CLASS(Localization.lang("%0 file", "CLASS"), "class"),
    JAR(Localization.lang("%0 file", "JAR"), "jar"),
    XML(Localization.lang("%0 file", "XML"), "xml"),
    ZIP(Localization.lang("%0 file", "ZIP"), "zip");

    private final String[] extension;
    private final String description;

    private FileExtensions(String description, String ... extension) {
        this.extension = extension;
        this.description = description;
    }

    public String[] getExtensions() {
        return this.extension;
    }

    public String getDescription() {
        StringJoiner sj = new StringJoiner(", ", this.description + " (", ")");
        for (String ext : this.extension) {
            sj.add("*." + ext);
        }
        return sj.toString();
    }

    public String getFirstExtensionWithDot() {
        return "." + this.extension[0].trim();
    }
}

