/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.logic.importer.fetcher.CrossRef;
import net.sf.jabref.model.entry.BibEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DOI {
    private static final Log LOGGER = LogFactory.getLog(DOI.class);
    public static final URI RESOLVER = URI.create("http://doi.org");
    private final String doi;
    private static final String DOI_EXP = "(?:urn:)?(?:doi:)?(10(?:\\.[0-9]+)+[/:](?:.+))";
    private static final String FIND_DOI_EXP = "(?:urn:)?(?:doi:)?(10(?:\\.[0-9]+)+[/:](?:[^\\s]+))";
    private static final String HTTP_EXP = "https?://[^\\s]+?(?:urn:)?(?:doi:)?(10(?:\\.[0-9]+)+[/:](?:.+))";
    private static final Pattern EXACT_DOI_PATT = Pattern.compile("^(?:https?://[^\\s]+?)?(?:urn:)?(?:doi:)?(10(?:\\.[0-9]+)+[/:](?:.+))$", 2);
    private static final Pattern DOI_PATT = Pattern.compile("(?:https?://[^\\s]+?)?(?:urn:)?(?:doi:)?(10(?:\\.[0-9]+)+[/:](?:[^\\s]+))", 2);

    public DOI(String doi) {
        Matcher matcher;
        Objects.requireNonNull(doi);
        String trimmedDoi = doi.trim();
        if (doi.matches(HTTP_EXP)) {
            try {
                URI url = new URI(trimmedDoi);
                trimmedDoi = url.getScheme() + "://" + url.getHost() + url.getPath();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(doi + " is not a valid HTTP DOI.");
            }
        }
        if (!(matcher = EXACT_DOI_PATT.matcher(trimmedDoi)).find()) {
            throw new IllegalArgumentException(trimmedDoi + " is not a valid DOI.");
        }
        this.doi = matcher.group(1);
    }

    public static Optional<DOI> build(String doi) {
        try {
            return Optional.ofNullable(new DOI(doi));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return Optional.empty();
        }
    }

    public static Optional<DOI> findInText(String text) {
        Optional<DOI> result = Optional.empty();
        Matcher matcher = DOI_PATT.matcher(text);
        if (matcher.find()) {
            result = Optional.of(new DOI(matcher.group(1)));
        }
        return result;
    }

    public static Optional<DOI> fromBibEntry(BibEntry entry) {
        return CrossRef.findDOI(entry);
    }

    public String getDOI() {
        return this.doi;
    }

    public Optional<URI> getURI() {
        try {
            URI uri = new URI(RESOLVER.getScheme(), RESOLVER.getHost(), "/" + this.doi, null);
            return Optional.of(uri);
        }
        catch (URISyntaxException e) {
            LOGGER.error(this.doi + " could not be encoded as URI.", e);
            return Optional.empty();
        }
    }

    public String getURIAsASCIIString() {
        return this.getURI().map(URI::toASCIIString).orElse("");
    }
}

