/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import net.sf.jabref.logic.util.Version;

public class BuildInfo {
    public static final String UNKNOWN_VERSION = "*unknown*";
    public static final String OS = System.getProperty("os.name", "*unknown*").toLowerCase();
    public static final String OS_VERSION = System.getProperty("os.version", "*unknown*").toLowerCase();
    public static final String OS_ARCH = System.getProperty("os.arch", "*unknown*").toLowerCase();
    public static final String JAVA_VERSION = System.getProperty("java.version", "*unknown*").toLowerCase();
    private final Version version;
    private final String authors;
    private final String developers;
    private final String year;

    public BuildInfo() {
        this("/build.properties");
    }

    public BuildInfo(String path) {
        Properties properties;
        block26: {
            properties = new Properties();
            try (InputStream stream = BuildInfo.class.getResourceAsStream(path);){
                if (stream == null) break block26;
                try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                    properties.load(reader);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.version = Version.parse(properties.getProperty("version"));
        this.authors = properties.getProperty("authors", "");
        this.year = properties.getProperty("year", "");
        this.developers = properties.getProperty("developers", "");
    }

    public Version getVersion() {
        return this.version;
    }

    public String getAuthors() {
        return this.authors;
    }

    public String getDevelopers() {
        return this.developers;
    }

    public String getYear() {
        return this.year;
    }
}

