/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.specialfields;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.sf.jabref.logic.util.UpdateField;
import net.sf.jabref.model.FieldChange;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.Keyword;
import net.sf.jabref.model.entry.KeywordList;
import net.sf.jabref.model.entry.specialfields.SpecialField;

@Deprecated
public class SpecialFieldsUtils {
    public static List<FieldChange> updateField(SpecialField field, String value, BibEntry entry, boolean nullFieldIfValueIsTheSame, boolean isKeywordSyncEnabled, Character keywordDelimiter) {
        ArrayList<FieldChange> fieldChanges = new ArrayList<FieldChange>();
        UpdateField.updateField(entry, field.getFieldName(), value, nullFieldIfValueIsTheSame).ifPresent(fieldChange -> fieldChanges.add((FieldChange)fieldChange));
        fieldChanges.addAll(SpecialFieldsUtils.exportFieldToKeywords(field, entry, isKeywordSyncEnabled, keywordDelimiter));
        return fieldChanges;
    }

    private static List<FieldChange> exportFieldToKeywords(SpecialField specialField, BibEntry entry, boolean isKeywordSyncEnabled, Character keywordDelimiter) {
        ArrayList<FieldChange> fieldChanges = new ArrayList<FieldChange>();
        if (!isKeywordSyncEnabled) {
            return fieldChanges;
        }
        Optional<Keyword> newValue = entry.getField(specialField.getFieldName()).map(Keyword::new);
        KeywordList keyWords = specialField.getKeyWords();
        Optional<FieldChange> change = entry.replaceKeywords(keyWords, newValue, keywordDelimiter);
        change.ifPresent(changeValue -> fieldChanges.add((FieldChange)changeValue));
        return fieldChanges;
    }

    public static List<FieldChange> syncKeywordsFromSpecialFields(BibEntry entry, boolean isKeywordSyncEnabled, Character keywordDelimiter) {
        ArrayList<FieldChange> fieldChanges = new ArrayList<FieldChange>();
        for (SpecialField field : SpecialField.values()) {
            fieldChanges.addAll(SpecialFieldsUtils.exportFieldToKeywords(field, entry, isKeywordSyncEnabled, keywordDelimiter));
        }
        return fieldChanges;
    }

    private static List<FieldChange> importKeywordsForField(KeywordList keywordList, SpecialField field, BibEntry entry) {
        ArrayList<FieldChange> fieldChanges = new ArrayList<FieldChange>();
        KeywordList values = field.getKeyWords();
        Optional<Keyword> newValue = Optional.empty();
        for (Keyword keyword : values) {
            if (!keywordList.contains(keyword)) continue;
            newValue = Optional.of(keyword);
            break;
        }
        UpdateField.updateNonDisplayableField(entry, field.getFieldName(), newValue.map(Keyword::toString).orElse(null)).ifPresent(fieldChange -> fieldChanges.add((FieldChange)fieldChange));
        return fieldChanges;
    }

    public static List<FieldChange> syncSpecialFieldsFromKeywords(BibEntry entry, Character keywordDelimiter) {
        ArrayList<FieldChange> fieldChanges = new ArrayList<FieldChange>();
        if (!entry.hasField("keywords")) {
            return fieldChanges;
        }
        KeywordList keywordList = entry.getKeywords(keywordDelimiter);
        for (SpecialField field : SpecialField.values()) {
            fieldChanges.addAll(SpecialFieldsUtils.importKeywordsForField(keywordList, field, entry));
        }
        return fieldChanges;
    }

    public static void synchronizeSpecialFields(KeywordList keywordsToAdd, KeywordList keywordsToRemove) {
        KeywordList clone = keywordsToAdd.createClone();
        for (SpecialField field : SpecialField.values()) {
            clone.retainAll(field.getKeyWords());
            if (clone.isEmpty()) continue;
            keywordsToRemove.addAll(field.getKeyWords());
        }
    }
}

