/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.search.rules.describer;

import net.sf.jabref.logic.search.rules.describer.ContainsAndRegexBasedSearchRuleDescriber;
import net.sf.jabref.logic.search.rules.describer.GrammarBasedSearchRuleDescriber;
import net.sf.jabref.logic.search.rules.describer.SearchDescriber;
import net.sf.jabref.model.search.rules.ContainBasedSearchRule;
import net.sf.jabref.model.search.rules.GrammarBasedSearchRule;
import net.sf.jabref.model.search.rules.RegexBasedSearchRule;
import net.sf.jabref.model.search.rules.SearchRule;

public class SearchDescribers {
    public static SearchDescriber getSearchDescriberFor(SearchRule searchRule, String query) {
        if (searchRule instanceof GrammarBasedSearchRule) {
            GrammarBasedSearchRule grammarBasedSearchRule = (GrammarBasedSearchRule)searchRule;
            return new GrammarBasedSearchRuleDescriber(grammarBasedSearchRule.isCaseSensitiveSearch(), grammarBasedSearchRule.isRegExpSearch(), grammarBasedSearchRule.getTree());
        }
        if (searchRule instanceof ContainBasedSearchRule) {
            ContainBasedSearchRule containBasedSearchRule = (ContainBasedSearchRule)searchRule;
            return new ContainsAndRegexBasedSearchRuleDescriber(containBasedSearchRule.isCaseSensitive(), false, query);
        }
        if (searchRule instanceof RegexBasedSearchRule) {
            RegexBasedSearchRule regexBasedSearchRule = (RegexBasedSearchRule)searchRule;
            return new ContainsAndRegexBasedSearchRuleDescriber(regexBasedSearchRule.isCaseSensitive(), true, query);
        }
        throw new IllegalStateException("Cannot find a describer for searchRule " + searchRule + " and query " + query);
    }
}

