/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.search.rules.describer;

import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.search.rules.describer.ContainsAndRegexBasedSearchRuleDescriber;
import net.sf.jabref.logic.search.rules.describer.SearchDescriber;
import net.sf.jabref.model.search.rules.GrammarBasedSearchRule;
import net.sf.jabref.model.strings.StringUtil;
import net.sf.jabref.search.SearchBaseVisitor;
import net.sf.jabref.search.SearchParser;
import org.antlr.v4.runtime.tree.ParseTree;

public class GrammarBasedSearchRuleDescriber
implements SearchDescriber {
    private final boolean caseSensitive;
    private final boolean regExp;
    private final ParseTree parseTree;

    public GrammarBasedSearchRuleDescriber(boolean caseSensitive, boolean regExp, ParseTree parseTree) {
        this.caseSensitive = caseSensitive;
        this.regExp = regExp;
        this.parseTree = Objects.requireNonNull(parseTree);
    }

    @Override
    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Localization.lang("This search contains entries in which", new String[0])).append(' ').append((String)new SearchBaseVisitor<String>(){

            @Override
            public String visitStart(SearchParser.StartContext context) {
                return (String)this.visit(context.expression());
            }

            @Override
            public String visitUnaryExpression(SearchParser.UnaryExpressionContext context) {
                return String.format("%s %s", Localization.lang("not", new String[0]), this.visit(context.expression()));
            }

            @Override
            public String visitParenExpression(SearchParser.ParenExpressionContext context) {
                return String.format("%s", context.expression());
            }

            @Override
            public String visitBinaryExpression(SearchParser.BinaryExpressionContext context) {
                if ("AND".equalsIgnoreCase(context.operator.getText())) {
                    return String.format("(%s %s %s)", this.visit(context.left), Localization.lang("and", new String[0]), this.visit(context.right));
                }
                return String.format("(%s %s %s)", this.visit(context.left), Localization.lang("or", new String[0]), this.visit(context.right));
            }

            @Override
            public String visitComparison(SearchParser.ComparisonContext context) {
                String fieldSpecQuoted;
                Optional<SearchParser.NameContext> fieldDescriptor = Optional.ofNullable(context.left);
                String value = StringUtil.unquote(context.right.getText(), '\"');
                if (!fieldDescriptor.isPresent()) {
                    return new ContainsAndRegexBasedSearchRuleDescriber(GrammarBasedSearchRuleDescriber.this.caseSensitive, GrammarBasedSearchRuleDescriber.this.regExp, value).getDescription();
                }
                String field = StringUtil.unquote(fieldDescriptor.get().getText(), '\"');
                GrammarBasedSearchRule.ComparisonOperator operator = GrammarBasedSearchRule.ComparisonOperator.build(context.operator.getText());
                boolean regExpFieldSpec = !Pattern.matches("\\w+", field);
                String termQuoted = StringUtil.quoteForHTML(value);
                String string = fieldSpecQuoted = regExpFieldSpec ? Localization.lang("any field that matches the regular expression <b>%0</b>", StringUtil.quoteForHTML(field)) : Localization.lang("the field <b>%0</b>", StringUtil.quoteForHTML(field));
                if (operator == GrammarBasedSearchRule.ComparisonOperator.CONTAINS) {
                    if (GrammarBasedSearchRuleDescriber.this.regExp) {
                        return Localization.lang("%0 contains the regular expression <b>%1</b>", fieldSpecQuoted, termQuoted);
                    }
                    return Localization.lang("%0 contains the term <b>%1</b>", fieldSpecQuoted, termQuoted);
                }
                if (operator == GrammarBasedSearchRule.ComparisonOperator.EXACT) {
                    if (GrammarBasedSearchRuleDescriber.this.regExp) {
                        return Localization.lang("%0 matches the regular expression <b>%1</b>", fieldSpecQuoted, termQuoted);
                    }
                    return Localization.lang("%0 matches the term <b>%1</b>", fieldSpecQuoted, termQuoted);
                }
                if (operator == GrammarBasedSearchRule.ComparisonOperator.DOES_NOT_CONTAIN) {
                    if (GrammarBasedSearchRuleDescriber.this.regExp) {
                        return Localization.lang("%0 doesn't contain the regular expression <b>%1</b>", fieldSpecQuoted, termQuoted);
                    }
                    return Localization.lang("%0 doesn't contain the term <b>%1</b>", fieldSpecQuoted, termQuoted);
                }
                throw new IllegalStateException("CANNOT HAPPEN!");
            }
        }.visit(this.parseTree));
        stringBuilder.append(". ");
        stringBuilder.append(this.caseSensitive ? Localization.lang("The search is case sensitive.", new String[0]) : Localization.lang("The search is case insensitive.", new String[0]));
        return stringBuilder.toString();
    }
}

