/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.search;

import com.google.common.eventbus.EventBus;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import net.sf.jabref.logic.search.SearchQuery;
import net.sf.jabref.logic.search.SearchQueryHighlightListener;

public class SearchQueryHighlightObservable {
    private final EventBus eventBus = new EventBus();
    private Optional<Pattern> pattern = Optional.empty();

    public void addSearchListener(SearchQueryHighlightListener newListener) {
        Objects.requireNonNull(newListener);
        this.eventBus.register(newListener);
        newListener.highlightPattern(this.pattern);
    }

    public void removeSearchListener(SearchQueryHighlightListener listener) {
        Objects.requireNonNull(listener);
        this.eventBus.unregister(listener);
    }

    public void fireSearchlistenerEvent(SearchQuery searchQuery) {
        Objects.requireNonNull(searchQuery);
        this.pattern = SearchQueryHighlightObservable.getPatternForWords(searchQuery.getSearchWords(), searchQuery.isRegularExpression(), searchQuery.isCaseSensitive());
        this.update();
    }

    public void reset() {
        this.pattern = Optional.empty();
        this.update();
    }

    private void update() {
        this.eventBus.post(this.pattern);
    }

    public static Optional<Pattern> getPatternForWords(List<String> words, boolean useRegex, boolean isCaseSensitive) {
        if (words == null || words.isEmpty() || words.get(0).isEmpty()) {
            return Optional.empty();
        }
        StringJoiner joiner = new StringJoiner(")|(", "(", ")");
        for (String word : words) {
            joiner.add(useRegex ? word : Pattern.quote(word));
        }
        String searchPattern = joiner.toString();
        if (isCaseSensitive) {
            return Optional.of(Pattern.compile(searchPattern));
        }
        return Optional.of(Pattern.compile(searchPattern, 2));
    }
}

