/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.remote.shared;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Protocol {
    public static final String IDENTIFIER = "jabref";
    private static final Log LOGGER = LogFactory.getLog(Protocol.class);
    private final Socket socket;
    private final OutputStream out;
    private final InputStream in;

    public Protocol(Socket socket) throws IOException {
        this.socket = socket;
        this.out = socket.getOutputStream();
        this.in = socket.getInputStream();
    }

    public void sendMessage(String message) throws IOException {
        this.out.write(message.getBytes());
        this.out.write(0);
        this.out.flush();
    }

    public String receiveMessage() throws IOException {
        StringBuilder result = new StringBuilder();
        try {
            int c;
            while ((c = this.in.read()) != 0 && c >= 0) {
                result.append((char)c);
            }
        }
        catch (SocketTimeoutException ex) {
            LOGGER.info("Connection timed out.", ex);
        }
        return result.toString();
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

