/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.remote.server;

import java.io.IOException;
import java.net.BindException;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.logic.remote.server.MessageHandler;
import net.sf.jabref.logic.remote.server.RemoteListenerServerThread;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteListenerServerLifecycle
implements AutoCloseable {
    private RemoteListenerServerThread remoteListenerServerThread;
    private static final Log LOGGER = LogFactory.getLog(RemoteListenerServerLifecycle.class);

    public void stop() {
        if (this.isOpen()) {
            this.remoteListenerServerThread.interrupt();
            this.remoteListenerServerThread = null;
        }
    }

    public void open(MessageHandler messageHandler, int port) {
        RemoteListenerServerThread result;
        if (this.isOpen()) {
            return;
        }
        try {
            result = new RemoteListenerServerThread(messageHandler, port);
        }
        catch (BindException e) {
            LOGGER.warn("Port is blocked", e);
            result = null;
        }
        catch (IOException e) {
            result = null;
        }
        this.remoteListenerServerThread = result;
    }

    public boolean isOpen() {
        return this.remoteListenerServerThread != null;
    }

    public void start() {
        if (this.isOpen() && this.isNotStartedBefore()) {
            JabRefExecutorService.INSTANCE.executeInOwnThread(this.remoteListenerServerThread);
        }
    }

    public boolean isNotStartedBefore() {
        return this.remoteListenerServerThread == null || this.remoteListenerServerThread.getState() == Thread.State.NEW;
    }

    public void openAndStart(MessageHandler messageHandler, int port) {
        this.open(messageHandler, port);
        this.start();
    }

    @Override
    public void close() {
        this.stop();
    }
}

