/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.remote.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import net.sf.jabref.logic.remote.server.MessageHandler;
import net.sf.jabref.logic.remote.shared.Protocol;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteListenerServer
implements Runnable {
    private static final Log LOGGER = LogFactory.getLog(RemoteListenerServer.class);
    private static final int BACKLOG = 1;
    private static final int ONE_SECOND_TIMEOUT = 1000;
    private final MessageHandler messageHandler;
    private final ServerSocket serverSocket;

    public RemoteListenerServer(MessageHandler messageHandler, int port) throws IOException {
        this.serverSocket = new ServerSocket(port, 1, InetAddress.getByName("localhost"));
        this.messageHandler = messageHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        block19: while (true) {
            while (!Thread.interrupted()) {
                try {
                    Socket socket = this.serverSocket.accept();
                    Throwable throwable = null;
                    try {
                        socket.setSoTimeout(1000);
                        Protocol protocol = new Protocol(socket);
                        protocol.sendMessage("jabref");
                        String message = protocol.receiveMessage();
                        protocol.close();
                        if (message.isEmpty()) continue;
                        this.messageHandler.handleMessage(message);
                        continue block19;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (socket == null) continue block19;
                        if (throwable != null) {
                            try {
                                socket.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue block19;
                        }
                        socket.close();
                    }
                }
                catch (SocketException ex) {
                    this.closeServerSocket();
                    return;
                }
                catch (IOException e) {
                    try {
                        LOGGER.warn("RemoteListenerServer crashed", e);
                        continue block19;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return;
                    }
                }
            }
        }
        finally {
            this.closeServerSocket();
        }
    }

    public void closeServerSocket() {
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

