/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.remote.client;

import java.net.InetAddress;
import java.net.Socket;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.remote.shared.Protocol;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteListenerClient {
    private static final Log LOGGER = LogFactory.getLog(RemoteListenerClient.class);
    private static final int TIMEOUT = 2000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static boolean sendToActiveJabRefInstance(String[] args, int remoteServerPort) {
        try {
            Throwable throwable = null;
            try (Socket socket = new Socket(InetAddress.getByName("localhost"), remoteServerPort);){
                Protocol protocol;
                block21: {
                    socket.setSoTimeout(2000);
                    protocol = new Protocol(socket);
                    try {
                        String identifier = protocol.receiveMessage();
                        if ("jabref".equals(identifier)) break block21;
                        String port = String.valueOf(remoteServerPort);
                        String error = Localization.lang("Cannot use port %0 for remote operation; another application may be using it. Try specifying another port.", port);
                        System.out.println(error);
                        boolean bl = false;
                        protocol.close();
                        return bl;
                    }
                    catch (Throwable throwable2) {
                        try {
                            protocol.close();
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                    }
                }
                protocol.sendMessage(String.join((CharSequence)"\n", args));
                boolean bl = true;
                protocol.close();
                return bl;
            }
        }
        catch (Exception e) {
            LOGGER.debug("Could not send args " + String.join((CharSequence)", ", args) + " to the server at port " + remoteServerPort, e);
            return false;
        }
    }
}

