/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.protectedterms;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.protectedterms.ProtectedTermsList;
import net.sf.jabref.logic.protectedterms.ProtectedTermsLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProtectedTermsParser {
    private final List<String> terms = new ArrayList<String>();
    private String description = Localization.lang("The text after the last line starting with # will be used", new String[0]);
    private String location;
    private static final Log LOGGER = LogFactory.getLog(ProtectedTermsParser.class);

    public void readTermsFromResource(String resourceFileName, String descriptionString) {
        URL url = Objects.requireNonNull(ProtectedTermsLoader.class.getResource(Objects.requireNonNull(resourceFileName)));
        this.description = descriptionString;
        this.location = resourceFileName;
        try {
            this.readTermsList(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            LOGGER.info("Could not read protected terms from resource " + resourceFileName, e);
        }
    }

    public void readTermsFromFile(File file) throws FileNotFoundException {
        this.location = file.getAbsolutePath();
        try (FileReader reader = new FileReader(Objects.requireNonNull(file));){
            this.readTermsList(reader);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            LOGGER.warn("Could not read terms from file " + file.getAbsolutePath(), e);
        }
    }

    public void readTermsFromFile(File file, Charset encoding) throws FileNotFoundException {
        this.location = file.getAbsolutePath();
        try (FileInputStream stream = new FileInputStream(Objects.requireNonNull(file));
             InputStreamReader reader = new InputStreamReader((InputStream)stream, Objects.requireNonNull(encoding));){
            this.readTermsList(reader);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            LOGGER.warn("Could not read terms from file " + file.getAbsolutePath(), e);
        }
    }

    private void readTermsList(Reader in) {
        try (BufferedReader reader = new BufferedReader(in);){
            String line;
            while ((line = reader.readLine()) != null) {
                this.addLine(line);
            }
        }
        catch (IOException ex) {
            LOGGER.info("Could not read journal list from file ", ex);
        }
    }

    private void addLine(String line) {
        if (line.startsWith("#")) {
            this.description = line.substring(1).trim();
            return;
        }
        this.terms.add(line);
    }

    public ProtectedTermsList getProtectTermsList(boolean enabled, boolean internal) {
        ProtectedTermsList termList = new ProtectedTermsList(this.description, this.terms, this.location, internal);
        termList.setEnabled(enabled);
        return termList;
    }
}

