/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.protectedterms;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.protectedterms.ProtectedTermsList;
import net.sf.jabref.logic.protectedterms.ProtectedTermsParser;
import net.sf.jabref.logic.protectedterms.ProtectedTermsPreferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProtectedTermsLoader {
    private static final Log LOGGER = LogFactory.getLog(ProtectedTermsLoader.class);
    private final List<ProtectedTermsList> mainList = new ArrayList<ProtectedTermsList>();
    private static final Map<String, String> internalLists = new HashMap<String, String>();

    public static List<String> getInternalLists() {
        return new ArrayList<String>(internalLists.keySet());
    }

    public ProtectedTermsLoader(ProtectedTermsPreferences preferences) {
        this.update(preferences);
    }

    public void update(ProtectedTermsPreferences preferences) {
        this.mainList.clear();
        for (String filename : preferences.getEnabledInternalTermLists()) {
            if (internalLists.containsKey(filename)) {
                this.mainList.add(ProtectedTermsLoader.readProtectedTermsListFromResource(filename, internalLists.get(filename), true));
                continue;
            }
            LOGGER.warn("Protected terms resource '" + filename + "' is no longer available.");
        }
        for (String filename : preferences.getDisabledInternalTermLists()) {
            if (internalLists.containsKey(filename)) {
                if (preferences.getEnabledInternalTermLists().contains(filename)) continue;
                this.mainList.add(ProtectedTermsLoader.readProtectedTermsListFromResource(filename, internalLists.get(filename), false));
                continue;
            }
            LOGGER.warn("Protected terms resource '" + filename + "' is no longer available.");
        }
        for (String filename : internalLists.keySet()) {
            if (preferences.getEnabledInternalTermLists().contains(filename) || preferences.getDisabledInternalTermLists().contains(filename)) continue;
            this.mainList.add(ProtectedTermsLoader.readProtectedTermsListFromResource(filename, internalLists.get(filename), true));
            LOGGER.warn("New protected terms resource '" + filename + "' is available and enabled by default.");
        }
        for (String filename : preferences.getEnabledExternalTermLists()) {
            try {
                this.mainList.add(ProtectedTermsLoader.readProtectedTermsListFromFile(new File(filename), true));
            }
            catch (FileNotFoundException e) {
                LOGGER.warn("Cannot find protected terms file " + filename, e);
            }
        }
        for (String filename : preferences.getDisabledExternalTermLists()) {
            if (preferences.getEnabledExternalTermLists().contains(filename)) continue;
            try {
                this.mainList.add(ProtectedTermsLoader.readProtectedTermsListFromFile(new File(filename), false));
            }
            catch (FileNotFoundException e) {
                LOGGER.warn("Cannot find protected terms file " + filename, e);
            }
        }
    }

    public void reloadProtectedTermsList(ProtectedTermsList list) {
        try {
            ProtectedTermsList newList = ProtectedTermsLoader.readProtectedTermsListFromFile(new File(list.getLocation()), list.isEnabled());
            int index = this.mainList.indexOf(list);
            if (index >= 0) {
                this.mainList.set(index, newList);
            } else {
                LOGGER.warn("Problem reloading protected terms file");
            }
        }
        catch (IOException e) {
            LOGGER.warn("Problem with protected terms file '" + list.getLocation() + "'", e);
        }
    }

    public List<ProtectedTermsList> getProtectedTermsLists() {
        return this.mainList;
    }

    public List<String> getProtectedTerms() {
        HashSet<String> result = new HashSet<String>();
        for (ProtectedTermsList list : this.mainList) {
            if (!list.isEnabled()) continue;
            result.addAll(list.getTermList());
        }
        return new ArrayList<String>(result);
    }

    public void addProtectedTermsListFromFile(String fileName, boolean enabled) {
        try {
            this.mainList.add(ProtectedTermsLoader.readProtectedTermsListFromFile(new File(fileName), enabled));
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Cannot find protected terms file " + fileName, e);
        }
    }

    public static ProtectedTermsList readProtectedTermsListFromResource(String resource, String description, boolean enabled) {
        ProtectedTermsParser parser = new ProtectedTermsParser();
        parser.readTermsFromResource(Objects.requireNonNull(resource), Objects.requireNonNull(description));
        return parser.getProtectTermsList(enabled, true);
    }

    public static ProtectedTermsList readProtectedTermsListFromFile(File file, boolean enabled) throws FileNotFoundException {
        LOGGER.debug("Reading term list from file " + file);
        ProtectedTermsParser parser = new ProtectedTermsParser();
        parser.readTermsFromFile(Objects.requireNonNull(file));
        return parser.getProtectTermsList(enabled, false);
    }

    public static ProtectedTermsList readProtectedTermsListFromFile(File file, Charset encoding, boolean enabled) throws FileNotFoundException {
        LOGGER.debug("Reading term list from file " + file);
        ProtectedTermsParser parser = new ProtectedTermsParser();
        parser.readTermsFromFile(Objects.requireNonNull(file), Objects.requireNonNull(encoding));
        return parser.getProtectTermsList(enabled, false);
    }

    public boolean removeProtectedTermsList(ProtectedTermsList termList) {
        termList.setEnabled(false);
        return this.mainList.remove(termList);
    }

    public ProtectedTermsList addNewProtectedTermsList(String newDescription, String newLocation, boolean enabled) {
        Objects.requireNonNull(newDescription);
        Objects.requireNonNull(newLocation);
        ProtectedTermsList resultingList = new ProtectedTermsList(newDescription, new ArrayList<String>(), newLocation);
        resultingList.setEnabled(enabled);
        resultingList.createAndWriteHeading(newDescription);
        this.mainList.add(resultingList);
        return resultingList;
    }

    public ProtectedTermsList addNewProtectedTermsList(String newDescription, String newLocation) {
        return this.addNewProtectedTermsList(newDescription, newLocation, true);
    }

    static {
        internalLists.put("/protectedterms/months_weekdays.terms", Localization.lang("Months and weekdays in English", new String[0]));
        internalLists.put("/protectedterms/countries_territories.terms", Localization.lang("Countries and territories in English", new String[0]));
        internalLists.put("/protectedterms/electrical_engineering.terms", Localization.lang("Electrical engineering terms", new String[0]));
    }
}

