/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.openoffice;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.sf.jabref.logic.layout.LayoutFormatterPreferences;
import net.sf.jabref.logic.openoffice.OOBibStyle;
import net.sf.jabref.logic.openoffice.OpenOfficePreferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StyleLoader {
    private static final Log LOGGER = LogFactory.getLog(StyleLoader.class);
    public static final String DEFAULT_AUTHORYEAR_STYLE_PATH = "/resource/openoffice/default_authoryear.jstyle";
    public static final String DEFAULT_NUMERICAL_STYLE_PATH = "/resource/openoffice/default_numerical.jstyle";
    private final List<String> internalStyleFiles = Arrays.asList("/resource/openoffice/default_authoryear.jstyle", "/resource/openoffice/default_numerical.jstyle");
    private final OpenOfficePreferences preferences;
    private final Charset encoding;
    private final LayoutFormatterPreferences layoutFormatterPreferences;
    private final List<OOBibStyle> internalStyles = new ArrayList<OOBibStyle>();
    private final List<OOBibStyle> externalStyles = new ArrayList<OOBibStyle>();

    public StyleLoader(OpenOfficePreferences preferences, LayoutFormatterPreferences jabrefPreferences, Charset encoding) {
        this.preferences = Objects.requireNonNull(preferences);
        this.layoutFormatterPreferences = Objects.requireNonNull(jabrefPreferences);
        this.encoding = Objects.requireNonNull(encoding);
        this.loadInternalStyles();
        this.loadExternalStyles();
    }

    public List<OOBibStyle> getStyles() {
        ArrayList<OOBibStyle> result = new ArrayList<OOBibStyle>(this.internalStyles);
        result.addAll(this.externalStyles);
        return result;
    }

    public boolean addStyleIfValid(String filename) {
        Objects.requireNonNull(filename);
        try {
            OOBibStyle newStyle = new OOBibStyle(new File(filename), this.layoutFormatterPreferences, this.encoding);
            if (this.externalStyles.contains(newStyle)) {
                LOGGER.info("External style file " + filename + " already existing.");
            } else {
                if (newStyle.isValid()) {
                    this.externalStyles.add(newStyle);
                    this.storeExternalStyles();
                    return true;
                }
                LOGGER.error(String.format("Style with filename %s is invalid", filename));
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.info("Cannot find external style file " + filename, e);
        }
        catch (IOException e) {
            LOGGER.info("Problem reading external style file " + filename, e);
        }
        return false;
    }

    private void loadExternalStyles() {
        this.externalStyles.clear();
        List<String> lists = this.preferences.getExternalStyles();
        for (String filename : lists) {
            try {
                OOBibStyle style = new OOBibStyle(new File(filename), this.layoutFormatterPreferences, this.encoding);
                if (style.isValid()) {
                    this.externalStyles.add(style);
                    continue;
                }
                LOGGER.error(String.format("Style with filename %s is invalid", filename));
            }
            catch (FileNotFoundException e) {
                LOGGER.info("Cannot find external style file " + filename, e);
            }
            catch (IOException e) {
                LOGGER.info("Problem reading external style file " + filename, e);
            }
        }
    }

    private void loadInternalStyles() {
        this.internalStyles.clear();
        for (String filename : this.internalStyleFiles) {
            try {
                this.internalStyles.add(new OOBibStyle(filename, this.layoutFormatterPreferences));
            }
            catch (IOException e) {
                LOGGER.info("Problem reading internal style file " + filename, e);
            }
        }
    }

    private void storeExternalStyles() {
        ArrayList<String> filenames = new ArrayList<String>(this.externalStyles.size());
        for (OOBibStyle style : this.externalStyles) {
            filenames.add(style.getPath());
        }
        this.preferences.setExternalStyles(filenames);
    }

    public boolean removeStyle(OOBibStyle style) {
        Objects.requireNonNull(style);
        if (!style.isFromResource()) {
            boolean result = this.externalStyles.remove(style);
            this.storeExternalStyles();
            return result;
        }
        return false;
    }

    public OOBibStyle getUsedStyle() {
        String filename = this.preferences.getCurrentStyle();
        if (filename != null) {
            for (OOBibStyle style : this.getStyles()) {
                if (!filename.equals(style.getPath())) continue;
                return style;
            }
        }
        this.preferences.setCurrentStyle(this.internalStyles.get(0).getPath());
        return this.internalStyles.get(0);
    }
}

