/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.openoffice;

import java.io.File;
import java.util.List;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.preferences.JabRefPreferences;

public class OpenOfficePreferences {
    private final JabRefPreferences preferences;
    public static final String DEFAULT_WINDOWS_PATH = "C:\\Program Files\\OpenOffice.org 4";
    public static final String WINDOWS_EXECUTABLE_SUBPATH = "\\program\\";
    public static final String WINDOWS_EXECUTABLE = "soffice.exe";
    public static final String WINDOWS_JARS_SUBPATH = "\\program\\classes";
    public static final String DEFAULT_OSX_PATH = "/Applications/OpenOffice.org.app";
    public static final String OSX_EXECUTABLE_SUBPATH = "/Contents/MacOS/";
    public static final String OSX_EXECUTABLE = "soffice.bin";
    public static final String OSX_JARS_SUBPATH = "/Contents/Resources/java";
    public static final String LINUX_EXECUTABLE = "soffice";

    public OpenOfficePreferences(JabRefPreferences preferences) {
        this.preferences = preferences;
    }

    public void updateConnectionParams(String ooPath, String execPath, String jarsPath) {
        this.setOOPath(ooPath);
        this.setExecutablePath(execPath);
        this.setJarsPath(jarsPath);
    }

    public boolean checkAutoDetectedPaths() {
        if (this.preferences.hasKey("ooJarsPath") && this.preferences.hasKey("ooExecutablePath")) {
            return new File(this.getJarsPath(), "jurt.jar").exists() && new File(this.getExecutablePath()).exists();
        }
        return false;
    }

    public String clearConnectionSettings() {
        this.preferences.clear("ooPath");
        this.preferences.clear("ooExecutablePath");
        this.preferences.clear("ooJarsPath");
        return Localization.lang("Cleared connection settings.", new String[0]);
    }

    public String getJarsPath() {
        return this.preferences.get("ooJarsPath");
    }

    public void setJarsPath(String path) {
        this.preferences.put("ooJarsPath", path);
    }

    public String getExecutablePath() {
        return this.preferences.get("ooExecutablePath");
    }

    public void setExecutablePath(String path) {
        this.preferences.put("ooExecutablePath", path);
    }

    public String getOOPath() {
        return this.preferences.get("ooPath");
    }

    public void setOOPath(String path) {
        this.preferences.put("ooPath", path);
    }

    public boolean useAllDatabases() {
        return this.preferences.getBoolean("useAllOpenBases");
    }

    public void setUseAllDatabases(boolean use) {
        this.preferences.putBoolean("useAllOpenBases", use);
    }

    public boolean syncWhenCiting() {
        return this.preferences.getBoolean("syncOOWhenCiting");
    }

    public void setSyncWhenCiting(boolean sync) {
        this.preferences.putBoolean("syncOOWhenCiting", sync);
    }

    public boolean showPanel() {
        return this.preferences.getBoolean("showOOPanel");
    }

    public void setShowPanel(boolean show) {
        this.preferences.putBoolean("showOOPanel", show);
    }

    public List<String> getExternalStyles() {
        return this.preferences.getStringList("ooExternalStyleFiles");
    }

    public void setExternalStyles(List<String> filenames) {
        this.preferences.putStringList("ooExternalStyleFiles", filenames);
    }

    public String getCurrentStyle() {
        return this.preferences.get("ooBibliographyStyleFile");
    }

    public void clearCurrentStyle() {
        this.preferences.remove("ooBibliographyStyleFile");
    }

    public void setCurrentStyle(String path) {
        this.preferences.put("ooBibliographyStyleFile", path);
    }
}

