/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.openoffice;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class OpenOfficeFileSearch {
    private boolean fileSearchCanceled;

    public List<File> findWindowsProgramFilesDir() {
        ArrayList<String> sourceList = new ArrayList<String>();
        ArrayList<File> dirList = new ArrayList<File>();
        String progFiles = System.getenv("ProgramFiles");
        if (progFiles != null) {
            sourceList.add(progFiles);
        }
        if ((progFiles = System.getenv("ProgramFiles(x86)")) != null) {
            sourceList.add(progFiles);
        }
        for (String rootPath : sourceList) {
            File root = new File(rootPath);
            File[] dirs = root.listFiles(File::isDirectory);
            if (dirs == null) continue;
            for (File dir : dirs) {
                if (!dir.getPath().contains("OpenOffice") && !dir.getPath().contains("LibreOffice")) continue;
                dirList.add(dir);
            }
        }
        return dirList;
    }

    public List<File> findOSXProgramFilesDir() {
        ArrayList<File> dirList = new ArrayList<File>();
        File rootDir = new File("/Applications");
        File[] files = rootDir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory() || !"OpenOffice.org.app".equals(file.getName()) && !"LibreOffice.app".equals(file.getName())) continue;
                dirList.add(file);
            }
        }
        return dirList;
    }

    public void resetFileSearch() {
        this.fileSearchCanceled = false;
    }

    public void cancelFileSearch() {
        this.fileSearchCanceled = true;
    }

    public List<File> findFileInDirs(List<File> dirList, String filename) {
        ArrayList<File> sofficeFiles = new ArrayList<File>();
        for (File dir : dirList) {
            if (this.fileSearchCanceled) break;
            this.findFileInDir(dir, filename).ifPresent(sofficeFiles::add);
        }
        return sofficeFiles;
    }

    public Optional<File> findFileInDir(File startDir, String filename) {
        if (this.fileSearchCanceled) {
            return Optional.empty();
        }
        File[] files = startDir.listFiles();
        if (files == null) {
            return Optional.empty();
        }
        Optional<File> result = Optional.empty();
        for (File file : files) {
            if (this.fileSearchCanceled) {
                return Optional.empty();
            }
            if (file.isDirectory()) {
                result = this.findFileInDir(file, filename);
                if (!result.isPresent()) continue;
                return result;
            }
            if (!file.getName().equals(filename)) continue;
            return Optional.of(startDir);
        }
        return result;
    }
}

