/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.openoffice;

import java.util.Map;
import net.sf.jabref.logic.layout.LayoutFormatter;
import net.sf.jabref.model.strings.HTMLUnicodeConversionMaps;
import net.sf.jabref.model.strings.StringUtil;

public class OOPreFormatter
implements LayoutFormatter {
    private static final Map<String, String> CHARS = HTMLUnicodeConversionMaps.LATEX_UNICODE_CONVERSION_MAP;

    @Override
    public String format(String field) {
        String finalResult = field.replaceAll("&|\\\\&", "&").replace("\\$", "&dollar;").replaceAll("\\$([^\\$]*)\\$", "\\{$1\\}");
        StringBuilder sb = new StringBuilder();
        StringBuilder currentCommand = null;
        boolean escaped = false;
        boolean incommand = false;
        for (int i = 0; i < finalResult.length(); ++i) {
            String result;
            String command;
            char c = finalResult.charAt(i);
            if (escaped && c == '\\') {
                sb.append('\\');
                escaped = false;
                continue;
            }
            if (c == '\\') {
                if (incommand) {
                    command = currentCommand.toString();
                    result = CHARS.get(command);
                    if (result == null) {
                        sb.append(command);
                    } else {
                        sb.append(result);
                    }
                }
                escaped = true;
                incommand = true;
                currentCommand = new StringBuilder();
                continue;
            }
            if (!incommand && (c == '{' || c == '}')) continue;
            if (Character.isLetter(c) || c == '%' || "\"`^~'=.|".contains(String.valueOf(c))) {
                escaped = false;
                if (!incommand) {
                    sb.append(c);
                    continue;
                }
                currentCommand.append(c);
                if (currentCommand.length() == 1 && "\"`^~'=.|".contains(currentCommand.toString())) {
                    String combody;
                    if (i >= finalResult.length() - 1) continue;
                    command = currentCommand.toString();
                    if ((c = finalResult.charAt(++i)) == '{') {
                        String part = StringUtil.getPart(finalResult, i, false);
                        i += part.length();
                        combody = part;
                    } else {
                        combody = finalResult.substring(i, i + 1);
                    }
                    String result2 = CHARS.get(command + combody);
                    if (result2 != null) {
                        sb.append(result2);
                    }
                    incommand = false;
                    escaped = false;
                    continue;
                }
                if (i + 1 != finalResult.length()) continue;
                command = currentCommand.toString();
                result = CHARS.get(command);
                if (result == null) {
                    sb.append(command);
                    continue;
                }
                sb.append(result);
                continue;
            }
            if (!incommand) {
                sb.append(c);
            } else if (Character.isWhitespace(c) || c == '{' || c == '}') {
                String result3;
                String part;
                String command2 = currentCommand.toString();
                String tag = this.getHTMLTag(command2);
                if (!tag.isEmpty()) {
                    part = StringUtil.getPart(finalResult, i, true);
                    i += part.length();
                    sb.append('<').append(tag).append('>').append(part).append("</").append(tag).append('>');
                } else if (c == '{') {
                    part = StringUtil.getPart(finalResult, i, true);
                    i += part.length();
                    String argument = part;
                    String result4 = CHARS.get(command2 + argument);
                    if (result4 == null) {
                        sb.append(argument);
                    } else {
                        sb.append(result4);
                    }
                } else if (c == '}') {
                    result3 = CHARS.get(command2);
                    if (result3 == null) {
                        sb.append(command2);
                    } else {
                        sb.append(result3);
                    }
                } else {
                    result3 = CHARS.get(command2);
                    if (result3 == null) {
                        sb.append(command2);
                    } else {
                        sb.append(result3);
                    }
                    sb.append(' ');
                }
            }
            incommand = false;
            escaped = false;
        }
        return sb.toString().replace("&dollar;", "$");
    }

    private String getHTMLTag(String latexCommand) {
        String result = "";
        switch (latexCommand) {
            case "textit": 
            case "it": 
            case "emph": 
            case "em": {
                result = "i";
                break;
            }
            case "textbf": 
            case "bf": {
                result = "b";
                break;
            }
            case "textsc": {
                result = "smallcaps";
                break;
            }
            case "underline": {
                result = "u";
                break;
            }
            case "sout": {
                result = "s";
                break;
            }
            case "texttt": {
                result = "tt";
                break;
            }
            case "textsuperscript": {
                result = "sup";
                break;
            }
            case "textsubscript": {
                result = "sub";
                break;
            }
        }
        return result;
    }
}

