/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.openoffice;

import java.util.Optional;

public class CitationEntry
implements Comparable<CitationEntry> {
    private final String refMarkName;
    private Optional<String> pageInfo;
    private final String context;
    private final Optional<String> origPageInfo;

    public CitationEntry(String refMarkName, String context) {
        this(refMarkName, context, Optional.empty());
    }

    public CitationEntry(String refMarkName, String context, String pageInfo) {
        this(refMarkName, context, Optional.ofNullable(pageInfo));
    }

    public CitationEntry(String refMarkName, String context, Optional<String> pageInfo) {
        this.refMarkName = refMarkName;
        this.context = context;
        this.pageInfo = pageInfo;
        this.origPageInfo = pageInfo;
    }

    public Optional<String> getPageInfo() {
        return this.pageInfo;
    }

    public String getRefMarkName() {
        return this.refMarkName;
    }

    public boolean pageInfoChanged() {
        if (this.pageInfo.isPresent() ^ this.origPageInfo.isPresent()) {
            return true;
        }
        if (this.pageInfo.isPresent()) {
            return this.pageInfo.get().compareTo(this.origPageInfo.get()) != 0;
        }
        return false;
    }

    @Override
    public int compareTo(CitationEntry other) {
        return this.refMarkName.compareTo(other.refMarkName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CitationEntry) {
            CitationEntry other = (CitationEntry)o;
            return this.refMarkName.equals(other.refMarkName);
        }
        return false;
    }

    public int hashCode() {
        return this.refMarkName.hashCode();
    }

    public String getContext() {
        return this.context;
    }

    public void setPageInfo(String trim) {
        this.pageInfo = Optional.ofNullable(trim);
    }
}

