/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.net;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class URLUtil {
    private static final String URL_EXP = "^(https?|ftp)://.+";
    private static final String GOOGLE_SEARCH_EXP = "^https?://(?:www\\.)?google\\.[\\.a-z]+?/url.*";

    public static String cleanGoogleSearchURL(String url) {
        Objects.requireNonNull(url);
        if (!url.matches(GOOGLE_SEARCH_EXP)) {
            return url;
        }
        try {
            String[] pairs;
            URL searchURL = new URL(url);
            String query = searchURL.getQuery();
            if (query == null) {
                return url;
            }
            for (String pair : pairs = query.split("&")) {
                String value;
                String decode;
                if (!pair.startsWith("url=") || !(decode = URLDecoder.decode(value = pair.substring(pair.indexOf(61) + 1, pair.length()), StandardCharsets.UTF_8.name())).matches(URL_EXP)) continue;
                return decode;
            }
            return url;
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            return url;
        }
    }

    public static boolean isURL(String url) {
        return url.contains("://");
    }
}

