/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class URLDownload {
    private static final Log LOGGER = LogFactory.getLog(URLDownload.class);
    private static final String USER_AGENT = "JabRef";
    private final URL source;
    private final Map<String, String> parameters = new HashMap<String, String>();
    private String postData = "";

    public static URLDownload createURLDownloadWithBrowserUserAgent(String address) throws MalformedURLException {
        URLDownload downloader = new URLDownload(address);
        downloader.addParameters("User-Agent", "Mozilla/5.0 (Windows NT 5.1; rv:31.0) Gecko/20100101 Firefox/31.0");
        return downloader;
    }

    public URLDownload(String address) throws MalformedURLException {
        this(new URL(address));
    }

    public URLDownload(URL source) {
        this.source = source;
        this.addParameters("User-Agent", USER_AGENT);
    }

    public URL getSource() {
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String determineMimeType() throws IOException {
        URLConnection urlConnection = this.openConnection();
        try {
            String string = urlConnection.getContentType();
            return string;
        }
        finally {
            try {
                urlConnection.getInputStream().close();
            }
            catch (IOException iOException) {}
        }
    }

    public void addParameters(String key, String value) {
        this.parameters.put(key, value);
    }

    public void setPostData(String postData) {
        if (postData != null) {
            this.postData = postData;
        }
    }

    private URLConnection openConnection() throws IOException {
        int status;
        HttpURLConnection connection = (HttpURLConnection)this.source.openConnection();
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            connection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        if (!this.postData.isEmpty()) {
            connection.setDoOutput(true);
            Throwable throwable = null;
            try (DataOutputStream wr = new DataOutputStream(connection.getOutputStream());){
                wr.writeBytes(this.postData);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        if ((status = connection.getResponseCode()) != 200 && (status == 302 || status == 301 || status == 303)) {
            String string = connection.getHeaderField("Location");
            connection = (HttpURLConnection)new URLDownload(string).openConnection();
        }
        connection.connect();
        return connection;
    }

    /*
     * Exception decompiling
     */
    public String downloadToString(Charset encoding) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<HttpCookie> getCookieFromUrl() throws IOException {
        CookieManager cookieManager = new CookieManager();
        CookieHandler.setDefault(cookieManager);
        cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        URLConnection con = this.openConnection();
        con.getHeaderFields();
        try {
            return cookieManager.getCookieStore().get(this.source.toURI());
        }
        catch (URISyntaxException e) {
            LOGGER.error("Unable to convert download URL to URI", e);
            return Collections.emptyList();
        }
    }

    private void copy(InputStream in, Writer out, Charset encoding) throws IOException {
        InputStream monitoredInputStream = this.monitorInputStream(in);
        InputStreamReader r = new InputStreamReader(monitoredInputStream, encoding);
        try (BufferedReader read = new BufferedReader(r);){
            String line;
            while ((line = read.readLine()) != null) {
                out.write(line);
                out.write("\n");
            }
        }
    }

    public void downloadToFile(File destination) throws IOException {
        try (BufferedInputStream input = new BufferedInputStream(this.openConnection().getInputStream());
             BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(destination));){
            this.copy(input, output);
        }
        catch (IOException e) {
            LOGGER.warn("Could not copy input", e);
            throw e;
        }
    }

    private void copy(InputStream in, OutputStream out) throws IOException {
        try (InputStream monitorInputStream = this.monitorInputStream(in);){
            int bytesRead;
            byte[] buffer = new byte[512];
            while ((bytesRead = monitorInputStream.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
        }
    }

    protected InputStream monitorInputStream(InputStream in) {
        return in;
    }

    public String toString() {
        return "URLDownload{source=" + this.source + '}';
    }
}

