/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.msbib;

import java.util.List;
import net.sf.jabref.model.entry.AuthorList;
import net.sf.jabref.model.strings.StringUtil;

public class PersonName {
    private String givenName;
    private String surname;
    private String middleName;

    public PersonName() {
    }

    public PersonName(String name) {
        this.parseName(name);
    }

    public PersonName(String firstName, String middleName, String lastName) {
        this.givenName = firstName;
        this.middleName = middleName;
        this.surname = lastName;
    }

    private void parseName(String author) {
        int amountOfNames;
        String authorMod = AuthorList.fixAuthorLastNameFirst(author, false);
        int endOfLastName = authorMod.indexOf(44);
        List<String> names = StringUtil.tokenizeToList(authorMod.substring(endOfLastName + 1).trim(), " \n\r");
        if (endOfLastName >= 0) {
            names.add(authorMod.substring(0, endOfLastName));
        }
        if ((amountOfNames = names.size()) == 1) {
            this.surname = names.get(0);
        } else if (amountOfNames == 2) {
            this.givenName = names.get(0);
            this.surname = names.get(1);
        } else {
            this.givenName = names.get(0);
            this.middleName = "";
            for (int i = 1; i < amountOfNames - 1; ++i) {
                this.middleName = this.middleName + ' ' + names.get(i);
            }
            this.middleName = this.middleName.trim();
            this.surname = names.get(amountOfNames - 1);
        }
    }

    public String getGivenNames() {
        StringBuilder result = new StringBuilder();
        if (this.givenName != null) {
            result.append(this.givenName);
        }
        if (this.middleName != null) {
            result.append(' ').append(this.middleName);
        }
        return result.toString();
    }

    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String lastName) {
        this.surname = lastName;
    }

    public String getFirstname() {
        return this.givenName;
    }

    public void setFirstname(String firstName) {
        this.givenName = firstName;
    }

    public String getMiddlename() {
        return this.middleName;
    }

    public void setMiddlename(String middleName) {
        this.middleName = middleName;
    }

    public String getFullname() {
        StringBuilder fullName = new StringBuilder();
        if (this.givenName != null && !this.givenName.isEmpty()) {
            fullName.append(this.givenName).append(' ');
        }
        if (this.middleName != null && !this.middleName.isEmpty()) {
            fullName.append(this.middleName).append(' ');
        }
        if (this.surname != null && !this.surname.isEmpty()) {
            fullName.append(this.surname);
        }
        return fullName.toString().trim();
    }

    public String toString() {
        return this.surname;
    }
}

