/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.msbib;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class PageNumbers {
    private String freeform;
    private int start;
    private int end;
    private static final Pattern PAGE_PATTERN = Pattern.compile("\\s*(\\d+)\\s*-{1,2}\\s*(\\d+)\\s*");

    public PageNumbers(String pages) {
        this.parsePageNums(pages);
    }

    private void parsePageNums(String pages) {
        Matcher matcher = PAGE_PATTERN.matcher(pages);
        if (matcher.matches()) {
            this.start = Integer.parseInt(matcher.group(1));
            this.end = Integer.parseInt(matcher.group(2));
        } else {
            this.freeform = pages;
        }
    }

    public Element getDOMrepresentation(Document document) {
        Element result = document.createElement("extent");
        result.setAttribute("unit", "page");
        if (this.freeform == null) {
            Element tmpStart = document.createElement("start");
            Element tmpEnd = document.createElement("end");
            tmpStart.appendChild(document.createTextNode(String.valueOf(this.start)));
            tmpEnd.appendChild(document.createTextNode(String.valueOf(this.end)));
            result.appendChild(tmpStart);
            result.appendChild(tmpEnd);
        } else {
            Text textNode = document.createTextNode(this.freeform);
            result.appendChild(textNode);
        }
        return result;
    }

    public String toString(String separator) {
        if (this.freeform != null) {
            return this.freeform;
        }
        return this.start + separator + this.end;
    }

    public String toString() {
        return this.toString("-");
    }
}

