/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.msbib;

import com.google.common.collect.HashBiMap;
import java.util.TreeMap;
import net.sf.jabref.logic.msbib.MSBibEntryType;
import net.sf.jabref.model.entry.BibLatexEntryTypes;
import net.sf.jabref.model.entry.BibtexEntryTypes;

public class MSBibMapping {
    private static final String BIBTEX_PREFIX = "BIBTEX_";
    private static final String MSBIB_PREFIX = "msbib-";
    private static final HashBiMap<String, String> biblatexToMsBib = HashBiMap.create();

    public static String getBibLaTeXEntryType(String msbibType) {
        String defaultType = BibtexEntryTypes.MISC.getName();
        TreeMap<String, String> entryTypeMapping = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        entryTypeMapping.put("Book", BibLatexEntryTypes.BOOK.getName());
        entryTypeMapping.put("BookSection", BibLatexEntryTypes.BOOK.getName());
        entryTypeMapping.put("JournalArticle", BibLatexEntryTypes.ARTICLE.getName());
        entryTypeMapping.put("ArticleInAPeriodical", BibLatexEntryTypes.PERIODICAL.getName());
        entryTypeMapping.put("ConferenceProceedings", BibLatexEntryTypes.INPROCEEDINGS.getName());
        entryTypeMapping.put("Report", BibLatexEntryTypes.TECHREPORT.getName());
        entryTypeMapping.put("Patent", BibLatexEntryTypes.PATENT.getName());
        entryTypeMapping.put("InternetSite", BibLatexEntryTypes.ONLINE.getName());
        return entryTypeMapping.getOrDefault(msbibType, defaultType);
    }

    public static MSBibEntryType getMSBibEntryType(String bibtexType) {
        TreeMap<String, MSBibEntryType> entryTypeMapping = new TreeMap<String, MSBibEntryType>(String.CASE_INSENSITIVE_ORDER);
        entryTypeMapping.put("book", MSBibEntryType.Book);
        entryTypeMapping.put("inbook", MSBibEntryType.BookSection);
        entryTypeMapping.put("booklet", MSBibEntryType.BookSection);
        entryTypeMapping.put("incollection", MSBibEntryType.BookSection);
        entryTypeMapping.put("article", MSBibEntryType.JournalArticle);
        entryTypeMapping.put("inproceedings", MSBibEntryType.ConferenceProceedings);
        entryTypeMapping.put("conference", MSBibEntryType.ConferenceProceedings);
        entryTypeMapping.put("proceedings", MSBibEntryType.ConferenceProceedings);
        entryTypeMapping.put("collection", MSBibEntryType.ConferenceProceedings);
        entryTypeMapping.put("techreport", MSBibEntryType.Report);
        entryTypeMapping.put("manual", MSBibEntryType.Report);
        entryTypeMapping.put("mastersthesis", MSBibEntryType.Report);
        entryTypeMapping.put("phdthesis", MSBibEntryType.Report);
        entryTypeMapping.put("unpublished", MSBibEntryType.Report);
        entryTypeMapping.put("patent", MSBibEntryType.Patent);
        entryTypeMapping.put("misc", MSBibEntryType.Misc);
        entryTypeMapping.put("electronic", MSBibEntryType.ElectronicSource);
        entryTypeMapping.put("online", MSBibEntryType.InternetSite);
        return entryTypeMapping.getOrDefault(bibtexType, MSBibEntryType.Misc);
    }

    public static int getLCID(String language) {
        return 0;
    }

    public static String getLanguage(int LCID) {
        return "english";
    }

    public static String getMSBibField(String bibtexFieldName) {
        return biblatexToMsBib.get(bibtexFieldName);
    }

    public static String getBibTeXField(String msbibFieldName) {
        return (String)biblatexToMsBib.inverse().get(msbibFieldName);
    }

    static {
        biblatexToMsBib.put("bibtexkey", "Tag");
        biblatexToMsBib.put("title", "Title");
        biblatexToMsBib.put("year", "Year");
        biblatexToMsBib.put("note", "Comments");
        biblatexToMsBib.put("volume", "Volume");
        biblatexToMsBib.put("language", "LCID");
        biblatexToMsBib.put("edition", "Edition");
        biblatexToMsBib.put("publisher", "Publisher");
        biblatexToMsBib.put("booktitle", "BookTitle");
        biblatexToMsBib.put("shorttitle", "ShortTitle");
        biblatexToMsBib.put("note", "Comments");
        biblatexToMsBib.put("chapter", "ChapterNumber");
        biblatexToMsBib.put("issue", "Issue");
        biblatexToMsBib.put("school", "Department");
        biblatexToMsBib.put("institution", "Institution");
        biblatexToMsBib.put("doi", "DOI");
        biblatexToMsBib.put("url", "URL");
        biblatexToMsBib.put("series", "BIBTEX_Series");
        biblatexToMsBib.put("abstract", "BIBTEX_Abstract");
        biblatexToMsBib.put("keywords", "BIBTEX_KeyWords");
        biblatexToMsBib.put("crossref", "BIBTEX_CrossRef");
        biblatexToMsBib.put("howpublished", "BIBTEX_HowPublished");
        biblatexToMsBib.put("affiliation", "BIBTEX_Affiliation");
        biblatexToMsBib.put("contents", "BIBTEX_Contents");
        biblatexToMsBib.put("copyright", "BIBTEX_Copyright");
        biblatexToMsBib.put("price", "BIBTEX_Price");
        biblatexToMsBib.put("size", "BIBTEX_Size");
        biblatexToMsBib.put("intype", "BIBTEX_InType");
        biblatexToMsBib.put("paper", "BIBTEX_Paper");
        biblatexToMsBib.put("key", "BIBTEX_Key");
        biblatexToMsBib.put("msbib-numberofvolume", "NumberVolumes");
        biblatexToMsBib.put("msbib-periodical", "PeriodicalTitle");
        biblatexToMsBib.put("msbib-day", "Day");
        biblatexToMsBib.put("msbib-accessed", "Accessed");
        biblatexToMsBib.put("msbib-medium", "Medium");
        biblatexToMsBib.put("msbib-recordingnumber", "RecordingNumber");
        biblatexToMsBib.put("msbib-theater", "Theater");
        biblatexToMsBib.put("msbib-distributor", "Distributor");
        biblatexToMsBib.put("msbib-broadcaster", "Broadcaster");
        biblatexToMsBib.put("msbib-station", "Station");
        biblatexToMsBib.put("msbib-type", "Type");
        biblatexToMsBib.put("msbib-court", "Court");
        biblatexToMsBib.put("msbib-reporter", "Reporter");
        biblatexToMsBib.put("msbib-casenumber", "CaseNumber");
        biblatexToMsBib.put("msbib-abbreviatedcasenumber", "AbbreviatedCaseNumber");
        biblatexToMsBib.put("msbib-productioncompany", "ProductionCompany");
    }
}

