/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.msbib;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.sf.jabref.logic.msbib.MSBibEntry;
import net.sf.jabref.logic.msbib.MSBibMapping;
import net.sf.jabref.logic.msbib.PageNumbers;
import net.sf.jabref.logic.msbib.PersonName;
import net.sf.jabref.model.entry.BibEntry;

public class MSBibConverter {
    private static final String MSBIB_PREFIX = "msbib-";
    private static final String BIBTEX_PREFIX = "BIBTEX_";

    public static MSBibEntry convert(BibEntry entry) {
        MSBibEntry result = new MSBibEntry();
        result.fields.put("BIBTEX_Entry", entry.getType());
        String msbibType = result.fields.put("SourceType", MSBibMapping.getMSBibEntryType(entry.getType()).name());
        for (String field : entry.getFieldNames()) {
            String unicodeField = entry.getLatexFreeField(field).orElse("");
            if (MSBibMapping.getMSBibField(field) == null) continue;
            result.fields.put(MSBibMapping.getMSBibField(field), unicodeField);
        }
        entry.getField("booktitle").ifPresent(booktitle -> {
            result.conferenceName = booktitle;
        });
        entry.getField("pages").ifPresent(pages -> {
            result.pages = new PageNumbers((String)pages);
        });
        entry.getField("msbib-accessed").ifPresent(accesed -> {
            result.dateAccessed = accesed;
        });
        if ("SoundRecording".equals(msbibType)) {
            result.albumTitle = entry.getField("title").orElse(null);
        }
        if ("Interview".equals(msbibType)) {
            result.broadcastTitle = entry.getField("title").orElse(null);
        }
        if (!entry.getField("issue").isPresent()) {
            result.number = entry.getField("number").orElse(null);
        }
        if ("Patent".equalsIgnoreCase(entry.getType())) {
            result.patentNumber = entry.getField("number").orElse(null);
            result.number = null;
        }
        result.journalName = entry.getFieldOrAlias("journal").orElse(null);
        result.month = entry.getFieldOrAlias("month").orElse(null);
        if (!entry.getField("year").isPresent()) {
            result.year = entry.getFieldOrAlias("year").orElse(null);
        }
        entry.getField("language").ifPresent(lang -> result.fields.put("LCID", String.valueOf(MSBibMapping.getLCID(lang))));
        StringBuilder sbNumber = new StringBuilder();
        entry.getField("isbn").ifPresent(isbn -> sbNumber.append(" ISBN: " + isbn));
        entry.getField("issn").ifPresent(issn -> sbNumber.append(" ISSN: " + issn));
        entry.getField("lccn").ifPresent(lccn -> sbNumber.append("LCCN: " + lccn));
        entry.getField("mrnumber").ifPresent(mrnumber -> sbNumber.append(" MRN: " + mrnumber));
        result.standardNumber = sbNumber.toString();
        if (result.standardNumber.isEmpty()) {
            result.standardNumber = null;
        }
        result.address = entry.getFieldOrAlias("address").orElse(null);
        if (entry.getField("type").isPresent()) {
            result.thesisType = entry.getField("type").get();
        } else if ("techreport".equalsIgnoreCase(entry.getType())) {
            result.thesisType = "Tech. rep.";
        } else if ("mastersthesis".equalsIgnoreCase(entry.getType())) {
            result.thesisType = "Master's thesis";
        } else if ("phdthesis".equalsIgnoreCase(entry.getType())) {
            result.thesisType = "Ph.D. dissertation";
        } else if ("unpublished".equalsIgnoreCase(entry.getType())) {
            result.thesisType = "unpublished";
        }
        if ("InternetSite".equals(msbibType) || "DocumentFromInternetSite".equals(msbibType)) {
            result.internetSiteTitle = entry.getField("title").orElse(null);
        }
        if ("ElectronicSource".equals(msbibType) || "Art".equals(msbibType) || "Misc".equals(msbibType)) {
            result.publicationTitle = entry.getField("title").orElse(null);
        }
        entry.getLatexFreeField("author").ifPresent(authors -> {
            result.authors = MSBibConverter.getAuthors(authors);
        });
        entry.getLatexFreeField("editor").ifPresent(editors -> {
            result.editors = MSBibConverter.getAuthors(editors);
        });
        return result;
    }

    private static List<PersonName> getAuthors(String authors) {
        ArrayList<PersonName> result = new ArrayList<PersonName>();
        if (authors.toUpperCase(Locale.ENGLISH).contains(" AND ")) {
            String[] names;
            for (String name : names = authors.split(" (?i)and ")) {
                result.add(new PersonName(name));
            }
        } else {
            result.add(new PersonName(authors));
        }
        return result;
    }
}

