/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.msbib;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.sf.jabref.logic.msbib.MSBibEntry;
import net.sf.jabref.logic.msbib.MSBibMapping;
import net.sf.jabref.logic.msbib.PersonName;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.MonthUtil;

public class BibTeXConverter {
    private static final String MSBIB_PREFIX = "msbib-";

    public static BibEntry convert(MSBibEntry entry) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        String bibTexEntryType = MSBibMapping.getBibLaTeXEntryType(entry.getType());
        BibEntry result = entry.getCiteKey() == null ? new BibEntry("__ID", bibTexEntryType) : new BibEntry(entry.getCiteKey(), bibTexEntryType);
        for (Map.Entry<String, String> field : entry.fields.entrySet()) {
            String msField = field.getKey();
            String value = field.getValue();
            if (value == null || MSBibMapping.getBibTeXField(msField) == null) continue;
            fieldValues.put(MSBibMapping.getBibTeXField(msField), value);
        }
        if (fieldValues.containsKey("language")) {
            int lcid = Integer.valueOf((String)fieldValues.get("language"));
            fieldValues.put("language", MSBibMapping.getLanguage(lcid));
        }
        BibTeXConverter.addAuthor(fieldValues, "author", entry.authors);
        BibTeXConverter.addAuthor(fieldValues, "msbib-bookauthor", entry.bookAuthors);
        BibTeXConverter.addAuthor(fieldValues, "editor", entry.editors);
        BibTeXConverter.addAuthor(fieldValues, "msbib-translator", entry.translators);
        BibTeXConverter.addAuthor(fieldValues, "msbib-producername", entry.producerNames);
        BibTeXConverter.addAuthor(fieldValues, "msbib-composer", entry.composers);
        BibTeXConverter.addAuthor(fieldValues, "msbib-conductor", entry.conductors);
        BibTeXConverter.addAuthor(fieldValues, "msbib-performer", entry.performers);
        BibTeXConverter.addAuthor(fieldValues, "msbib-writer", entry.writers);
        BibTeXConverter.addAuthor(fieldValues, "msbib-director", entry.directors);
        BibTeXConverter.addAuthor(fieldValues, "msbib-compiler", entry.compilers);
        BibTeXConverter.addAuthor(fieldValues, "msbib-interviewer", entry.interviewers);
        BibTeXConverter.addAuthor(fieldValues, "msbib-interviewee", entry.interviewees);
        BibTeXConverter.addAuthor(fieldValues, "msbib-inventor", entry.inventors);
        BibTeXConverter.addAuthor(fieldValues, "msbib-counsel", entry.counsels);
        if (entry.pages != null) {
            fieldValues.put("pages", entry.pages.toString("--"));
        }
        BibTeXConverter.parseStandardNumber(entry.standardNumber, fieldValues);
        if (entry.address != null) {
            fieldValues.put("location", entry.address);
        }
        if (entry.conferenceName != null) {
            fieldValues.put("organization", entry.conferenceName);
        }
        if (entry.dateAccessed != null) {
            fieldValues.put("msbib-accessed", entry.dateAccessed);
        }
        if (entry.journalName != null) {
            fieldValues.put("journaltitle", entry.journalName);
        }
        if (entry.month != null) {
            MonthUtil.Month month = MonthUtil.getMonth(entry.month);
            fieldValues.put("month", month.shortName);
        }
        if (entry.number != null) {
            fieldValues.put("number", entry.number);
        }
        result.setField(fieldValues);
        return result;
    }

    private static void addAuthor(Map<String, String> map, String type, List<PersonName> authors) {
        if (authors == null) {
            return;
        }
        String allAuthors = authors.stream().map(PersonName::getFullname).collect(Collectors.joining(" and "));
        map.put(type, allAuthors);
    }

    private static void parseSingleStandardNumber(String type, String bibtype, String standardNum, Map<String, String> map) {
        Pattern pattern = Pattern.compile(':' + type + ":(.[^:]+)");
        Matcher matcher = pattern.matcher(standardNum);
        if (matcher.matches()) {
            map.put(bibtype, matcher.group(1));
        }
    }

    private static void parseStandardNumber(String standardNum, Map<String, String> map) {
        if (standardNum == null) {
            return;
        }
        BibTeXConverter.parseSingleStandardNumber("ISBN", "isbn", standardNum, map);
        BibTeXConverter.parseSingleStandardNumber("ISSN", "issn", standardNum, map);
        BibTeXConverter.parseSingleStandardNumber("LCCN", "lccn", standardNum, map);
        BibTeXConverter.parseSingleStandardNumber("MRN", "mrnumber", standardNum, map);
        BibTeXConverter.parseSingleStandardNumber("DOI", "doi", standardNum, map);
    }
}

