/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.logging;

import java.util.LinkedList;
import java.util.Queue;

public class Cache {
    public static final int DEFAULT_CAPACITY = 500;
    private final int capacity;
    private final Queue<String> queue = new LinkedList<String>();
    private String cache = "";
    private boolean cacheRefreshNeeded = true;

    public Cache() {
        this(500);
    }

    public Cache(int capacity) {
        this.capacity = capacity;
    }

    public synchronized String get() {
        this.ensureCacheIsFresh();
        return this.cache;
    }

    private void ensureCacheIsFresh() {
        if (this.cacheRefreshNeeded) {
            this.cache = String.join((CharSequence)"", this.queue);
        }
    }

    public synchronized void add(String message) {
        this.queue.add(message);
        if (this.isCapacityExceeded()) {
            this.cacheRefreshNeeded = true;
            this.truncateLog();
        } else {
            this.cache = this.cache + message;
        }
    }

    private void truncateLog() {
        while (this.isCapacityExceeded()) {
            this.queue.poll();
        }
    }

    private boolean isCapacityExceeded() {
        return this.queue.size() > this.capacity;
    }
}

