/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.layout.format;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.sf.jabref.logic.layout.AbstractParamLayoutFormatter;
import net.sf.jabref.logic.layout.format.FileLinkPreferences;
import net.sf.jabref.logic.util.io.FileUtil;
import net.sf.jabref.model.entry.FileField;
import net.sf.jabref.model.entry.ParsedFileField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WrapFileLinks
extends AbstractParamLayoutFormatter {
    private static final Log LOGGER = LogFactory.getLog(WrapFileLinks.class);
    private String fileType;
    private List<FormatEntry> format;
    private final Map<String, String> replacements = new HashMap<String, String>();
    private static final int STRING = 0;
    private static final int ITERATION_COUNT = 1;
    private static final int FILE_PATH = 2;
    private static final int FILE_TYPE = 3;
    private static final int FILE_EXTENSION = 4;
    private static final int FILE_DESCRIPTION = 5;
    private static final int RELATIVE_FILE_PATH = 6;
    private static final Map<Character, Integer> ESCAPE_SEQ = new HashMap<Character, Integer>();
    private final FileLinkPreferences prefs;

    public WrapFileLinks(FileLinkPreferences fileLinkPreferences) {
        this.prefs = fileLinkPreferences;
    }

    @Override
    public void setArgument(String arg) {
        List<String> parts = AbstractParamLayoutFormatter.parseArgument(arg);
        this.format = WrapFileLinks.parseFormatString(parts.get(0));
        if (parts.size() > 1 && !parts.get(1).trim().isEmpty()) {
            this.fileType = parts.get(1);
        }
        if (parts.size() > 2) {
            for (int i = 2; i < parts.size() - 1; i += 2) {
                this.replacements.put(parts.get(i), parts.get(i + 1));
            }
        }
    }

    @Override
    public String format(String field) {
        if (field == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        List<ParsedFileField> fileList = FileField.parse(field);
        int piv = 1;
        for (ParsedFileField flEntry : fileList) {
            if (this.fileType != null && !flEntry.getFileType().equalsIgnoreCase(this.fileType)) continue;
            for (FormatEntry entry : this.format) {
                switch (entry.getType()) {
                    case 0: {
                        sb.append(entry.getString());
                        break;
                    }
                    case 1: {
                        sb.append(piv);
                        break;
                    }
                    case 2: {
                        List<String> dirs = this.prefs.getFileDirForDatabase() == null || this.prefs.getFileDirForDatabase().isEmpty() ? this.prefs.getGeneratedDirForDatabase() : this.prefs.getFileDirForDatabase();
                        Optional<File> f = FileUtil.expandFilename(flEntry.getLink(), dirs);
                        if (f.isPresent()) {
                            try {
                                sb.append(this.replaceStrings(f.get().getCanonicalPath()));
                            }
                            catch (IOException ex) {
                                LOGGER.warn("Problem getting path", ex);
                                sb.append(this.replaceStrings(f.get().getPath()));
                            }
                            break;
                        }
                        sb.append(this.replaceStrings(flEntry.getLink()));
                        break;
                    }
                    case 6: {
                        sb.append(this.replaceStrings(flEntry.getLink()));
                        break;
                    }
                    case 4: {
                        FileUtil.getFileExtension(flEntry.getLink()).ifPresent(extension -> sb.append(this.replaceStrings((String)extension)));
                        break;
                    }
                    case 3: {
                        sb.append(this.replaceStrings(flEntry.getFileType()));
                        break;
                    }
                    case 5: {
                        sb.append(this.replaceStrings(flEntry.getDescription()));
                        break;
                    }
                }
            }
            ++piv;
        }
        return sb.toString();
    }

    private String replaceStrings(String text) {
        String result = text;
        for (Map.Entry<String, String> stringStringEntry : this.replacements.entrySet()) {
            String to = stringStringEntry.getValue();
            result = result.replaceAll(stringStringEntry.getKey(), to);
        }
        return result;
    }

    private static List<FormatEntry> parseFormatString(String format) {
        ArrayList<FormatEntry> l = new ArrayList<FormatEntry>();
        StringBuilder sb = new StringBuilder();
        boolean escaped = false;
        for (int i = 0; i < format.length(); ++i) {
            char c = format.charAt(i);
            if (escaped) {
                escaped = false;
                if (c == '\\') {
                    sb.append('\\');
                    continue;
                }
                if (ESCAPE_SEQ.containsKey(Character.valueOf(c))) {
                    if (sb.length() > 0) {
                        l.add(new FormatEntry(sb.toString()));
                        sb = new StringBuilder();
                    }
                    l.add(new FormatEntry(ESCAPE_SEQ.get(Character.valueOf(c))));
                    continue;
                }
                sb.append('\\');
                sb.append(c);
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 0) {
            l.add(new FormatEntry(sb.toString()));
        }
        return l;
    }

    static {
        ESCAPE_SEQ.put(Character.valueOf('i'), 1);
        ESCAPE_SEQ.put(Character.valueOf('p'), 2);
        ESCAPE_SEQ.put(Character.valueOf('r'), 6);
        ESCAPE_SEQ.put(Character.valueOf('f'), 3);
        ESCAPE_SEQ.put(Character.valueOf('x'), 4);
        ESCAPE_SEQ.put(Character.valueOf('d'), 5);
    }

    static class FormatEntry {
        private final int type;
        private String string;

        public FormatEntry(int type) {
            this.type = type;
        }

        public FormatEntry(String value) {
            this.type = 0;
            this.string = value;
        }

        public int getType() {
            return this.type;
        }

        public String getString() {
            return this.string;
        }
    }
}

