/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.layout.format;

import java.util.Map;
import net.sf.jabref.logic.layout.LayoutFormatter;
import net.sf.jabref.model.strings.HTMLUnicodeConversionMaps;
import net.sf.jabref.model.strings.StringUtil;

public class HTMLChars
implements LayoutFormatter {
    private static final Map<String, String> HTML_CHARS = HTMLUnicodeConversionMaps.LATEX_HTML_CONVERSION_MAP;

    @Override
    public String format(String inField) {
        String field = inField.replaceAll("&|\\\\&", "&amp;").replaceAll("[\\n]{2,}", "<p>").replace("\n", "<br>").replace("\\$", "&dollar;").replaceAll("\\$([^\\$]*)\\$", "\\{$1\\}");
        StringBuilder sb = new StringBuilder();
        StringBuilder currentCommand = null;
        boolean escaped = false;
        boolean incommand = false;
        for (int i = 0; i < field.length(); ++i) {
            String result;
            String part;
            String result2;
            String command;
            char c = field.charAt(i);
            if (escaped && c == '\\') {
                sb.append('\\');
                escaped = false;
                continue;
            }
            if (c == '\\') {
                if (incommand) {
                    command = currentCommand.toString();
                    result2 = HTML_CHARS.get(command);
                    if (result2 == null) {
                        sb.append(command);
                    } else {
                        sb.append(result2);
                    }
                }
                escaped = true;
                incommand = true;
                currentCommand = new StringBuilder();
                continue;
            }
            if (!incommand && (c == '{' || c == '}')) continue;
            if (Character.isLetter(c) || c == '%' || "\"`^~'=.|".contains(String.valueOf(c))) {
                escaped = false;
                if (!incommand) {
                    sb.append(c);
                    continue;
                }
                currentCommand.append(c);
                if (currentCommand.length() == 1 && "\"`^~'=.|".contains(currentCommand.toString())) {
                    String commandBody;
                    if (i >= field.length() - 1) continue;
                    command = currentCommand.toString();
                    if ((c = field.charAt(++i)) == '{') {
                        part = StringUtil.getPart(field, i, false);
                        i += part.length();
                        commandBody = part;
                    } else {
                        commandBody = field.substring(i, i + 1);
                    }
                    result = HTML_CHARS.get(command + commandBody);
                    if (result == null) {
                        sb.append(commandBody);
                    } else {
                        sb.append(result);
                    }
                    incommand = false;
                    escaped = false;
                    continue;
                }
                if (i + 1 != field.length()) continue;
                command = currentCommand.toString();
                result2 = HTML_CHARS.get(command);
                if (result2 == null) {
                    sb.append(command);
                    continue;
                }
                sb.append(result2);
                continue;
            }
            if (!incommand) {
                sb.append(c);
            } else if (Character.isWhitespace(c) || c == '{' || c == '}') {
                command = currentCommand.toString();
                String tag = this.getHTMLTag(command);
                if (!tag.isEmpty()) {
                    part = StringUtil.getPart(field, i, true);
                    i += part.length();
                    sb.append('<').append(tag).append('>').append(part).append("</").append(tag).append('>');
                } else if (c == '{') {
                    String argument = StringUtil.getPart(field, i, true);
                    i += argument.length();
                    String result3 = HTML_CHARS.get(command + argument);
                    if (result3 == null) {
                        if (argument.isEmpty()) {
                            sb.append(command);
                        } else {
                            sb.append(argument);
                        }
                    } else {
                        sb.append(result3);
                    }
                } else if (c == '}') {
                    result = HTML_CHARS.get(command);
                    if (result == null) {
                        sb.append(command);
                    } else {
                        sb.append(result);
                    }
                } else {
                    result = HTML_CHARS.get(command);
                    if (result == null) {
                        sb.append(command);
                    } else {
                        sb.append(result);
                    }
                    sb.append(' ');
                }
            }
            incommand = false;
            escaped = false;
        }
        return sb.toString().replace("~", "&nbsp;");
    }

    private String getHTMLTag(String latexCommand) {
        String result = "";
        switch (latexCommand) {
            case "textit": 
            case "it": {
                result = "i";
                break;
            }
            case "emph": 
            case "em": {
                result = "em";
                break;
            }
            case "textbf": 
            case "bf": {
                result = "b";
                break;
            }
            case "underline": {
                result = "u";
                break;
            }
            case "sout": {
                result = "s";
                break;
            }
            case "texttt": {
                result = "tt";
                break;
            }
            case "textsuperscript": {
                result = "sup";
                break;
            }
            case "textsubscript": {
                result = "sub";
                break;
            }
        }
        return result;
    }
}

