/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.layout.format;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import net.sf.jabref.logic.layout.ParamLayoutFormatter;
import net.sf.jabref.logic.layout.format.FileLinkPreferences;
import net.sf.jabref.logic.util.io.FileUtil;
import net.sf.jabref.model.entry.FileField;
import net.sf.jabref.model.entry.ParsedFileField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileLink
implements ParamLayoutFormatter {
    private static final Log LOGGER = LogFactory.getLog(FileLink.class);
    private String fileType;
    private final FileLinkPreferences prefs;

    public FileLink(FileLinkPreferences fileLinkPreferences) {
        this.prefs = fileLinkPreferences;
    }

    @Override
    public String format(String field) {
        String link;
        block7: {
            List<ParsedFileField> fileList;
            block6: {
                if (field == null) {
                    return "";
                }
                fileList = FileField.parse(field);
                link = null;
                if (this.fileType != null) break block6;
                if (fileList.isEmpty()) break block7;
                link = fileList.get(0).getLink();
                break block7;
            }
            for (ParsedFileField flEntry : fileList) {
                if (!flEntry.getFileType().equalsIgnoreCase(this.fileType)) continue;
                link = flEntry.getLink();
                break;
            }
        }
        if (link == null) {
            return "";
        }
        List<String> dirs = this.prefs.getFileDirForDatabase() == null ? this.prefs.getGeneratedDirForDatabase() : this.prefs.getFileDirForDatabase();
        Optional<File> f = FileUtil.expandFilename(link, dirs);
        if (f.isPresent()) {
            try {
                return f.get().getCanonicalPath();
            }
            catch (IOException e) {
                LOGGER.warn("Problem getting path", e);
                return f.get().getPath();
            }
        }
        return link;
    }

    @Override
    public void setArgument(String arg) {
        this.fileType = arg;
    }
}

