/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.layout.format;

import net.sf.jabref.logic.layout.LayoutFormatter;
import net.sf.jabref.logic.layout.format.XMLChars;
import net.sf.jabref.model.entry.Author;
import net.sf.jabref.model.entry.AuthorList;

public class CreateDocBookAuthors
implements LayoutFormatter {
    private static final XMLChars XML_CHARS = new XMLChars();

    @Override
    public String format(String fieldText) {
        StringBuilder sb = new StringBuilder(100);
        AuthorList al = AuthorList.parse(fieldText);
        this.addBody(sb, al, "author");
        return sb.toString();
    }

    public void addBody(StringBuilder sb, AuthorList al, String tagName) {
        for (int i = 0; i < al.getNumberOfAuthors(); ++i) {
            sb.append('<').append(tagName).append('>');
            Author a = al.getAuthor(i);
            a.getFirst().filter(first -> !first.isEmpty()).ifPresent(first -> sb.append("<firstname>").append(XML_CHARS.format((String)first)).append("</firstname>"));
            a.getVon().filter(von -> !von.isEmpty()).ifPresent(von -> sb.append("<othername>").append(XML_CHARS.format((String)von)).append("</othername>"));
            a.getLast().filter(last -> !last.isEmpty()).ifPresent(last -> {
                sb.append("<surname>").append(XML_CHARS.format((String)last));
                a.getJr().filter(jr -> !jr.isEmpty()).ifPresent(jr -> sb.append(' ').append(XML_CHARS.format((String)jr)));
                sb.append("</surname>");
            });
            if (i < al.getNumberOfAuthors() - 1) {
                sb.append("</").append(tagName).append(">\n       ");
                continue;
            }
            sb.append("</").append(tagName).append('>');
        }
    }
}

