/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.layout.format;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sf.jabref.logic.layout.LayoutFormatter;

public class CompositeFormat
implements LayoutFormatter {
    private final List<LayoutFormatter> formatters;

    public CompositeFormat() {
        this.formatters = Collections.emptyList();
    }

    public CompositeFormat(LayoutFormatter first, LayoutFormatter second) {
        this.formatters = Arrays.asList(first, second);
    }

    public CompositeFormat(LayoutFormatter[] formatters) {
        this.formatters = Arrays.asList(formatters);
    }

    @Override
    public String format(String fieldText) {
        String result = fieldText;
        for (LayoutFormatter formatter : this.formatters) {
            result = formatter.format(result);
        }
        return result;
    }
}

